% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_getMUSICInterpolatedDopplerCellsIndex}
\alias{seasonder_getMUSICInterpolatedDopplerCellsIndex}
\title{Retrieve Interpolated Doppler Cells Index from a SeaSondeRCS Object}
\usage{
seasonder_getMUSICInterpolatedDopplerCellsIndex(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object containing MUSIC data.}
}
\value{
A vector of indices corresponding to the interpolated Doppler cells.
}
\description{
This function extracts the index of interpolated Doppler cells, stored in the MUSIC_data attribute of a SeaSondeRCS object.
}
\details{
The interpolated doppler cells index is part of the MUSIC_data and is used to identify
which Doppler bins were introduced during the interpolation process.
}
\examples{
# Minimal example for seasonder_getMUSICInterpolatedDopplerCellsIndex
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
doppler_index <- seasonder_getMUSICInterpolatedDopplerCellsIndex(cs_obj)
print(doppler_index)
}
