% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_getMUSICDopplerInterpolation}
\alias{seasonder_getMUSICDopplerInterpolation}
\alias{seasonder_getSeaSondeRCS_MUSIC_doppler_interpolation}
\title{Retrieve the Doppler Interpolation Factor from MUSIC Options}
\usage{
seasonder_getMUSICDopplerInterpolation(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object containing MUSIC data and options.}
}
\value{
An integer representing the Doppler interpolation factor.
}
\description{
This function obtains the Doppler interpolation factor used in the MUSIC algorithm from a SeaSondeRCS object.
}
\details{
The function accesses the MUSIC_data attribute under MUSIC_options and retrieves the doppler_interpolation parameter.
If absent, it defaults to 1L.
}
\examples{
# Assuming cs_object is a valid SeaSondeRCS object.
# Minimal example for seasonder_getMUSICDopplerInterpolation
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
interp_factor <- seasonder_getMUSICDopplerInterpolation(cs_obj)
print(interp_factor)
}
