% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_exportRangeInfo}
\alias{seasonder_exportRangeInfo}
\title{Export Range Information from a SeaSondeRCS Object}
\usage{
seasonder_exportRangeInfo(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object containing MUSIC data and associated metadata.}
}
\value{
A data frame with the following columns:
\describe{
\item{SPRC}{Range cell identifier.}
\item{RNGC}{Range (in appropriate units).}
\item{NF01}{Noise level (in dB) for antenna 1.}
\item{NF02}{Noise level (in dB) for antenna 2.}
\item{NF03}{Noise level (in dB) for antenna 3.}
\item{ALM1}{Lower FOR boundary (after Doppler interpolation).}
\item{ALM2}{Upper FOR boundary (after Doppler interpolation) for the first boundary set.}
\item{ALM3}{Lower FOR boundary (after Doppler interpolation) for the second boundary set.}
\item{ALM4}{Upper FOR boundary (after Doppler interpolation) for the second boundary set.}
\item{NVSC}{Count of detections classified as "single".}
\item{NVDC}{Count of detections classified as "dual".}
\item{NVAC}{Total adjusted count (NVSC plus twice NVDC).}
}
}
\description{
This function computes and exports range-related information based on the MUSIC data stored in a SeaSondeRCS object.
The output table includes range cell identifiers, range values, noise levels (for each antenna), first-order region
(FOR) boundaries, and counts of detections classified as single or dual solutions.
}
\details{
The function performs the following operations:
\enumerate{
\item Extracts key fields from the MUSIC data: range cell, range, and the retained solution type.
\item Aggregates counts of detections classified as single versus dual solutions.
\item Retrieves noise levels (in dB) for each antenna.
\item Obtains FOR boundaries using a dedicated export function and adjusts them based on the Doppler
interpolation factor.
\item Merges the aggregated detection counts, noise levels, and FOR boundaries by range cell.
\item Selects and reorders the output columns.
}
}
\examples{
\donttest{
# Prepare a SeaSondeRCS object with MUSIC data
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
FOR <- seasonder_getSeaSondeRCS_FOR(cs_obj)
cs_obj <- seasonder_setSeaSondeRCS_FOR(cs_obj,FOR[4:5])
# Run MUSIC algorithm to populate MUSIC data
cs_obj <- seasonder_runMUSICInFOR(cs_obj)
range_info <- seasonder_exportRangeInfo(cs_obj)
head(range_info)
}
}
