% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_computeFORs}
\alias{seasonder_computeFORs}
\title{Compute First Order Regions (FOR) Based on Selected Method}
\usage{
seasonder_computeFORs(seasonder_cs_object, method = NULL, FOR_control = NULL)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing the spectral data and FOR parameters.}

\item{method}{Optional; A character string specifying the method to be used for FOR computation.
Defaults to \code{NULL}, in which case the method stored in the object is used.
Currently supported method: \code{"SeaSonde"}.}

\item{FOR_control}{Optional; A list of parameters for configuring the FOR computation process.
Defaults to \code{NULL}, in which case the parameters already stored in the object are used.}
}
\value{
The updated \code{SeaSondeRCS} object with the computed First Order Regions (FOR).
}
\description{
This function processes a \code{SeaSondeRCS} object to compute the First Order Regions (FOR)
using the specified method. It allows the user to configure the processing method and parameters dynamically.
}
\details{
\strong{Steps:}
\enumerate{
\item \strong{Set Method:}
\itemize{
\item If a method is provided, it updates the \code{SeaSondeRCS} object with the specified method.
}
\item \strong{Retrieve Method:}
\itemize{
\item If no method is specified, the function retrieves the method stored in the object.
}
\item \strong{Set Parameters:}
\itemize{
\item If \code{FOR_control} is provided, the function updates the object's FOR parameters.
}
\item \strong{Method Execution:}
\itemize{
\item Based on the selected method, the corresponding processing function is called. Currently, the only
supported method is \code{"SeaSonde"}, which calls \code{\link{seasonder_computeFORsSeaSondeMethod}}.
}
}

\strong{Use Case:}
This function provides a flexible interface for computing FORs, allowing users to dynamically select
methods and configure parameters without modifying the internal object structure.
}
\examples{
# Set sample file paths
seasonder_disableMessages()
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
# Read the antenna pattern file to create a SeaSondeRAPM object
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
# Create a SeaSondeRCS object from a spectral file
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
cs_obj <- seasonder_computeFORs(cs_obj, method = "SeaSonde")
# Retrieve existing FOR control parameters from the object
FOR_control <- seasonder_getSeaSondeRCS_FORConfig(cs_obj)
cs_obj <- seasonder_computeFORs(cs_obj, FOR_control = FOR_control)
}
\seealso{
\itemize{
\item \code{\link{seasonder_computeFORsSeaSondeMethod}} for processing FORs using the SeaSonde method.
\item \code{\link{seasonder_setSeaSondeRCS_FOR_method}} for setting the processing method.
\item \code{\link{seasonder_setFOR_parameters}} for configuring FOR parameters.
}
}
