% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_computeBinsRadialVelocity}
\alias{seasonder_computeBinsRadialVelocity}
\title{Compute Radial Velocities for Doppler Bins}
\usage{
seasonder_computeBinsRadialVelocity(seasonder_cs_object, freq)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing data and metadata
necessary for the calculation of Doppler bin frequencies and velocities.}

\item{freq}{A numeric vector representing the Doppler frequencies for which
the radial velocities are to be calculated.}
}
\value{
A numeric vector containing the radial velocities (in meters per second, m/s)
corresponding to the provided Doppler frequencies.
}
\description{
This function calculates the radial velocities corresponding to the Doppler bins
in a SeaSondeRCS object, based on the provided Doppler frequencies. The calculation
uses the radar's wave number and Bragg angular frequencies.
}
\details{
The radial velocity \eqn{v} for each Doppler bin is computed using the formula:
\deqn{v = \frac{\text{Freq} - \text{BraggFreq}}{2 \cdot k_0}}
where:
\itemize{
\item \eqn{\text{Freq}} is the Doppler frequency of the bin.
\item \eqn{\text{BraggFreq}} is the Bragg Doppler angular frequency for the bin.
\item \eqn{k_0} is the radar wave number divided by \eqn{2\pi}.
}

The Bragg frequency is negative for bins with frequencies below zero and positive
for bins with frequencies above zero.
}
\seealso{
\code{\link{seasonder_getBraggDopplerAngularFrequency}} to retrieve the Bragg angular frequencies.
\code{\link{seasonder_getRadarWaveNumber}} to obtain the radar wave number.
}
