% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stress_moment.R
\name{stress_mean_sd}
\alias{stress_mean_sd}
\title{Stressing Mean and Standard Deviation}
\usage{
stress_mean_sd(
  x,
  k,
  new_means,
  new_sd,
  normalise = TRUE,
  names = NULL,
  log = FALSE,
  ...
)
}
\arguments{
\item{x}{A vector, matrix or data frame
containing realisations of random variables. Columns of \code{x}
correspond to random variables; OR\cr
A \code{SWIM} object, where \code{x} corresponds to the
underlying data of the \code{SWIM} object.}

\item{k}{Numeric vector, the columns of \code{x} that
are stressed.}

\item{new_means}{Numeric vector, same length as \code{k},
containing the stressed means.}

\item{new_sd}{Numeric vector, same length as \code{k},
containing the stressed standard deviations.}

\item{normalise}{Logical. If true, values of \code{f(x)} are linearly
scaled to the unit interval.}

\item{names}{Character vector, the names of stressed models.}

\item{log}{Boolean, the option to print weights' statistics.}

\item{...}{Additional arguments to be passed to
\code{\link[nleqslv]{nleqslv}} or
\code{\link{stress_moment}}.}
}
\value{
A \code{SWIM} object containing:
    \itemize{
      \item \code{x}, a data.frame containing the data;
      \item \code{new_weights}, a list, each component corresponds to
   a different stress and is a vector of scenario weights;
     \item \code{type = "mean"};
      \item \code{specs}, a list, each component corresponds to
   a different stress and contains \code{k}, \code{new_means} and
   \code{new_sd}.
   }
   See \code{\link{SWIM}} for details.
}
\description{
Provides weights on simulated scenarios from a baseline stochastic
    model, such that stressed model components (random variables)
    fulfil the mean and standard deviation constraints.
    Scenario weights are selected by constrained minimisation of
    the relative entropy to the baseline model.
}
\details{
The function \code{stress_mean_sd} is a wrapper for the
    function \code{stress_moment}. See \code{\link{stress_moment}}
    for details on the additional arguments to \code{...} and
    the underlying algorithm.

    For stressing means only, see \code{\link{stress_mean}},
    for stressing higher moments and functions of moments,
    see \code{\link{stress_moment}}.
}
\examples{
set.seed(0)
x <- data.frame(cbind(
  "normal" = rnorm(1000),
  "gamma" = rgamma(1000, shape = 2),
  "beta" = rbeta(1000, shape1 = 2, shape2 = 2)))
## stressing mean and sd of column 1
res1 <- stress(type = "mean sd", x = x, k = 1, new_means = 0.1,
  new_sd = 1.1, method = "Newton",
  control = list(maxit = 1000, ftol = 1E-15))
summary(res1)
## calling stress_mean_sd directly
res2 <- stress_mean_sd(x = x, k = 1, new_means = 0.1,
  new_sd = 1.1, method = "Newton",
  control = list(maxit = 1000, ftol = 1E-15))

## See also examples in stress_moment.

}
\references{
\insertRef{Pesenti2019reverse}{SWIM}\cr

    \insertRef{Pesenti2020SSRN}{SWIM}\cr

    \insertRef{Csiszar1975}{SWIM}
}
\seealso{
Other stress functions: 
\code{\link{stress_HARA_RM_w}()},
\code{\link{stress_RM_mean_sd_w}()},
\code{\link{stress_RM_w}()},
\code{\link{stress_VaR_ES}()},
\code{\link{stress_VaR}()},
\code{\link{stress_mean_sd_w}()},
\code{\link{stress_mean_w}()},
\code{\link{stress_mean}()},
\code{\link{stress_moment}()},
\code{\link{stress_prob}()},
\code{\link{stress_user}()},
\code{\link{stress_wass}()},
\code{\link{stress}()}
}
\concept{stress functions}
