% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdf_multivariate.R
\name{cdf_stressed}
\alias{cdf_stressed}
\title{Empirical Distribution Function of a Stressed Model}
\usage{
cdf_stressed(object, xCol = 1, wCol = "all", grid, base = FALSE)
}
\arguments{
\item{object}{A \code{SWIM} or \code{SWIMw} object.}

\item{xCol}{Numeric, (name of) the column of the underlying data 
of the \code{object} (\code{default = 1}).}

\item{wCol}{Vector or characters, the columns of the scenario weights 
of the \code{object} (\code{default = "all"}).}

\item{grid}{Vector, the empirical distribution of the \code{xCol} component
of the stressed model with weights \code{wCol}.}

\item{base}{Logical, if TRUE, statistics under the baseline are also returned (default = "FALSE").]}
}
\value{
A matrix containing the empirical distribution function 
        applied to \code{grid} of the \code{xCol} components of the 
        stressed model with weights \code{wCol}.
}
\description{
Provides the empirical distribution of a stressed model component (random variable) under the scenario weights
}
\details{
The \code{cdf_stressed} returns the values of the empirical distribution function 
         of the \code{xCol} model components for weights \code{wCol}. In contrast, the \code{cdf} function 
         returns a function, analogous to the \code{ecdf} from the base package. The 
         function \code{cdf_stressed} is the \code{cdf} function applied to grid.
}
\examples{
     
## example with a stress on VaR
set.seed(0)
x <- as.data.frame(cbind(
  "normal" = rnorm(1000), 
  "gamma" = rgamma(1000, shape = 2)))
res1 <- stress(type = "VaR", x = x, 
  alpha = c(0.9, 0.95), q_ratio = 1.05)
grid <- seq(min(x$normal), max(x$normal), length.out = 5)
## stressed empirical distribution function
cdf_stressed(res1, xCol = 1, wCol = "all", grid = grid)

}
\seealso{
See \code{\link{cdf}} for the empirical distribution function of a stressed 
    model component and \code{\link{quantile_stressed}} for sample quantiles of 
    a stressed model.
}
\author{
Kent Wu
}
