% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_eigenvalue.R
\name{est_eigenvalue}
\alias{est_eigenvalue}
\title{Eigenvalues of An Estimated Long-run Covariance Function}
\usage{
est_eigenvalue(este, K, h_power, estev)
}
\arguments{
\item{este}{Estimated errors in the long-run covariance function, inputted in a matrix form with each row representing each observation of the functional error values on equidistant points of any prespecified interval.}

\item{K}{Kernel function in the estimation of the long-run covariance function.}

\item{h_power}{Power of sample size 'N' (valued in (0,1)) for the smoothing bandwidth in the kernel function.}

\item{estev}{Number of the largest eigenvalues chosen in the output.}
}
\value{
A vector of first 'estev' largest eigenvalues in descending order.
}
\description{
Calculate the eigenvalues of an estimated long-run covariance function.
}
\examples{
N<-100
EE<-matrix(rep(0,N*100),ncol=100)
set.seed(1)
for (i in 1:N) {
temp<-rnorm(100,0,1)
EE[i,1]<-temp[1]
for (j in 2:100) {
EE[i,j]<-EE[i,j-1]+temp[j]
}
}
est_eigenvalue(este=EE,K=default_kernel,h_power=1/2,estev=10)
}
