% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treegram.R
\name{treegram}
\alias{treegram}
\title{Treegram}
\usage{
treegram(object, select = NULL, pos = NULL, col = NULL, mai = c(0.2, 0,
  0.2, 0.2), print.pos = TRUE, cex.text = 0.95, x.factor = 1.7,
  x.digits = 0, y.digits = 2, y.intersp = 1.45, cex.legend = 0.9)
}
\arguments{
\item{object}{requires the result object of seqtab function}

\item{select}{select items to be plotted}

\item{pos}{position of items on the x-axis}

\item{col}{color code or name for paths}

\item{mai}{numeric vector of the form c(bottom, left, top, right)
which gives the margin size specified in inches}

\item{print.pos}{display x/y-position as legend}

\item{cex.text}{text expansion factor relative to current par("cex")}

\item{x.factor}{shift factor of legend position}

\item{x.digits}{decimal places of x-position}

\item{y.digits}{decimal places of y-position}

\item{y.intersp}{legend character interspacing factor for vertical (y) line distances}

\item{cex.legend}{legend character expansion factor relative to current par("cex)}
}
\description{
This function draws a treegram for the Takea Semantic Structure Analysis (TSSA) and Sakai Sequential Relation Analysis (SSRA)
}
\details{
Takea Semantic Structure Analysis (TSSA) and Sakai Sequential Relation Analysis (SSRA) are graphical approaches
}
\examples{
# Example data based on Takeya (1991)

# Sakai Sequential Relation Analysis
# ordering assesed according to the correlation coefficient and mean difference
exdat.ssra <- SSRA(exdat, output = FALSE)
exdat.seqtab <- seqtable(exdat.ssra, output = FALSE)
treegram(exdat.seqtab)

# Select items to be plotted
exdat.ssra <- SSRA(exdat, output = FALSE)
exdat.seqtab <- seqtable(exdat.ssra, output = FALSE)
treegram(exdat.seqtab, select = c("Item2", "Item3", "Item4"))

# Define position for each item on the x-axis
exdat.ssra <- SSRA(exdat, output = FALSE)
exdat.seqtab <- seqtable(exdat.ssra, output = FALSE)
treegram(exdat.seqtab, pos = c(Item5 = 1, Item4 = 3,
                               Item3 = 5, Item2 = 2, Item1 = 4))

# Change colors for each path of an item
exdat.ssra <- SSRA(exdat, output = FALSE)
exdat.seqtab <- seqtable(exdat.ssra, output = FALSE)
treegram(exdat.seqtab,
         col = c(Item5 = "red3", Item4 = "blue3",
                 Item3 = "gray99", Item2 = "darkgreen", Item1 = "darkorange2"))
}
\author{
Takuya Yanagida
Keiko Sakai
}
\references{
Takeya, M. (1991). \emph{A new test theory: Structural analyses for educational information}.
Tokyo: Waseda University Press.
}
\seealso{
\code{\link{seqtable}}
}

