% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SRTfit.R
\name{srtsim_fit}
\alias{srtsim_fit}
\title{Fit the marginal distributions for each row of a count matrix}
\usage{
srtsim_fit(
  simsrt,
  marginal = c("auto_choose", "zinb", "nb", "poisson", "zip"),
  sim_scheme = c("tissue", "domain"),
  min_nonzero_num = 2,
  maxiter = 500
)
}
\arguments{
\item{simsrt}{A SRTsim object}

\item{marginal}{Specification of the types of marginal distribution.Default value is 'auto_choose' which chooses between ZINB, NB, ZIP, and Poisson by a likelihood ratio test (lrt),AIC and whether there is underdispersion.'zinb' will fit the ZINB model. If there is underdispersion, it will fit the Poisson model. If there is no zero at all or an error occurs, it will fit an NB model instead.'nb' fits the NB model and chooses between NB and Poisson depending on whether there is underdispersion. 'poisson' simply fits the Poisson model.'zip' fits the ZIP model and chooses between ZIP and Poisson by a likelihood ratio test}

\item{sim_scheme}{a character string specifying simulation scheme. "tissue" stands for tissue-based
simulation; "domain" stands for domain-specific simulation. Default is "tissue".}

\item{min_nonzero_num}{The minimum number of non-zero values required for a gene to be fitted. Default is 2.}

\item{maxiter}{The number of iterations for the model-fitting. Default is 500.}
}
\value{
Returns an object with estimated parameters
}
\description{
Fit the marginal distributions for each row of a count matrix
}
\examples{

## Create a simSRT object
toySRT  <- createSRT(count_in=toyData$toyCount,loc_in = toyData$toyInfo)
set.seed(1)
## Estimate model parameters for data generation
toySRT <- srtsim_fit(toySRT,sim_schem="tissue")

}
