% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LungCap.R
\docType{data}
\name{LungCap}
\alias{LungCap}
\title{Lung capacity}
\format{
A data frame with 654 rows (each child) and 5 columns:
\describe{
  \item{Age}{The age of the child, in years}
  \item{FEV}{The forced expiratory volume, in litres}
  \item{Ht}{The height, in inches}
  \item{Gender}{The gender of the child; one of \code{F} or \code{M}}
  \item{Smoke}{Whether the child is a smoker; one of \code{0} (non-smoker) or \code{1} (smoker)}
}
}
\source{
Kahn, M. (2003) Data Sleuth, \emph{STATS}, \bold{37}, 24.

Ira B. Tager, Scott T. Weiss, Alvaro Munoz, Bernard Rosner, 
and Frank E. Speizer (1983).
Longitudinal study of the effects of maternal smoking on 
pulmonary function in children. 
\emph{New England Journal of Medicine}, \bold{309}(12):699--703.
}
\usage{
data(LungCap)
}
\description{
The lung capacity of children.
}
\examples{
plot(FEV ~ Age, data = LungCap, xlab = "Age (years)", ylab = "FEV (L)")

}
\references{
Kahn, Michael (2005). 
An exhalent problem for teaching statistics. 
\emph{The Journal of Statistical Education}, \bold{13}(2). Available on-line.
}
\keyword{datasets}
