% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/graphics.R
\name{plot.SRCS}
\alias{animatedplot}
\alias{plot.SRCS}
\alias{singleplot}
\title{Heatmap plot of the ranking achieved by a target variable levels after all statistical pairwise comparisons in multi-parameter problem instances.}
\usage{
\method{plot}{SRCS}(x, yOuter, xOuter, yInner, xInner, zInner = "rank",
  out.Y.par = list(), out.X.par = list(), inner.X.par = list(),
  inner.Y.par = list(), colorbar.par = list(),
  color.function = heat.colors, heatmaps.per.row = NULL,
  heatmaps.titles = NULL, show.colorbar = TRUE, annotation.lab = NULL,
  heat.cell.par = list(), heat.axes.par = list(),
  colorbar.cell.par = list(), colorbar.axes.par = list(),
  annotation.text.par = list(), ...)

animatedplot(x, filename, path.to.converter, yOuter, xOuter, yInner, xInner,
  zInner, width = 800, height = 800, res = 100, pointsize = 16,
  delay = 30, type = c("png", "jpeg", "bmp", "tiff"), quality = 75,
  compression = c("none", "rle", "lzw", "jpeg", "zip"), annotations = NULL,
  ...)

singleplot(x, yInner, xInner, zInner = "rank", color.function = heat.colors,
  labels.par = list(), colorbar.par = list(), heat.axes.par = list(),
  colorbar.axes.par = list(), haxis = TRUE, vaxis = TRUE, title = "",
  show.colorbar = TRUE, ...)
}
\arguments{
\item{x}{An SRCS object containing columns for the names of the problem parameters (including the algorithm) and the rank obtained
by that algorithm when compared with the rest over the same problem configuration. Typically this is the object returned by a call to \code{\link{SRCSranks}}.}

\item{yOuter,xOuter}{Names of the variables in \code{x} that will be placed vertically (in the left-most part) and horizontally (on the top), respectively.
Each level of \code{yOuter} (resp. \code{xOuter}) corresponds to a complete row (complete column) of heatmaps in the grid.}

\item{yInner,xInner}{Names of the variables in \code{x} that will be placed on the Y axis and on the X axis of every heatmap, respectively.
Each level of \code{yInner} (resp. \code{xInner}) corresponds to a row (column) inside a heatmap.}

\item{zInner}{Name of the variable in \code{x} that will be represented with a color code inside every heatmap. Usually corresponds to the ranking column of \code{x},
   which will most often contain integer values (negatives are allowed). When the SRCS object being plotted has been returned by a call to \code{SRCSranks},
   this column is called "rank".
   For \code{\link{animatedplot}}, it should be a vector of strings containing the names of the ranks
columns that will be depicted, each at a time, sorted by time instant (from the earliest to the most recent).}

\item{out.Y.par,out.X.par}{A tagged list with parameters to configure how the labels of the outer Y and X variables and their levels are displayed.
    Valid parameters and their default values are as follows:
\itemize{
    \item{\code{lab = TRUE}}{ Label with the name of the variable. Will be displayed vertically
    for the outer Y variable and horizontally for the outer X variable. Valid values: FALSE for no label;
    NULL or TRUE for the name of the outer variable; and any string for a specific label. Defaults to TRUE.}
    \item{\code{lab.width = lcm(1)}}{ Width of the left-most column (for the outer Y variable) or top row (for the outer X variable) containing the name of the variable.}
    \item{\code{lab.textpar = list(cex = 1.6)}}{ Rest of parameters that will be passed to \code{\link{text}} to display this label.
        Parameter \code{cex} (text magnification factor) will be set 1.6 by default when not provided. }
    \item{\code{levels.lab = TRUE}}{ Whether a label should be displayed (or not) for every level of the variable. }
    \item{\code{levels.lab.width = lcm(1)}}{    Width of the row or column containing the levels of the variable.}
    \item{\code{levels.lab.textpar = list(cex = 1.4)}}{ Tagged list with more parameters that will be passed directly to \code{\link{text}} to display this label.
        Parameter \code{cex} (text magnification factor) will be set 1.4 by default when not provided.
        NOTE: if present, the value of parameter \code{str} will always be overwritten by 0 (horizontal text) for the outer X, and 90 (vertical text) for the outer Y variable.}
    \item{\code{lab.bg = NULL}}{ Background color of the rectangle where the label is placed. Default is transparent.
        No additional checks will be done concerning the validity of this parameter.}
    \item{\code{levels.bg = NULL}}{ Background color of the rectangle where the levels of the label are placed. Default is transparent.
        No additional checks will be done concerning the validity of this parameter.}
    \item{\code{lab.border = NULL}}{ Border color of the rectangle where the label is placed. Defaults to NULL (no line).
        No additional checks will be done concerning the validity of this parameter.}
    \item{\code{levels.border    = NULL}}{ Line color of the rectangle border where the levels of this label are placed. Defaults to NULL (no line).
        No additional checks will be done concerning the validity of this parameter.}
}}

\item{inner.X.par,inner.Y.par}{A tagged list with parameters to configure how the labels of the innter Y and X variables and their levels are displayed.
Valid parameters and their default values are the following:
\itemize{
    \item{\code{lab = TRUE}}{    Inner label to be shown. Valid values are FALSE for no label, NULL or TRUE for the name of variable passed as argument to \code{\link{plot.SRCS}},
                                                        or any string for a specific label. Defaults to TRUE.}
    \item{\code{lab.width = lcm(1)}}{ Width of the optional space for the label of the inner Y variable.
        The label will be repeated along the rows of the left-most column of heatmaps.}
    \item{\code{lab.textpar = list(cex = 1)}}{    Rest of parameters passed to \code{\link{text}} to display this label. }
    \item{\code{levels.loc = c("bottom", "left", "all", "none")}}{ Location of the inner level labels: only in heatmaps of the left-most column or the bottom row,
        or in every heatmap of the plot, or none. Defaults to "bottom" for the inner X variable and "left" for the inner Y variable.
        When levels.loc is set to "none", the value of params[["levels.at"]] is ignored.}
    \item{\code{levels.at = NULL}}{ Levels of the inner variable where the label will be shown. Defaults to all the levels. They can be provided in any order,
        since the order in which they will be displayed only depends on the order defined by the levels argument when that factor column of the data was created.}
    \item{\code{levels.las = 1}}{ Orientation of the level labels of this variable, defined as in \code{\link{axis}}. 1 for horizontal, 2  for vertical.}
}}

\item{colorbar.par}{Tagged list to configure the aspect of the colorbar legend displayed on the right part of the figure:
\itemize{
    \item{\code{levels.at = NULL}}{ String vector: Levels at which the Y axis ticks of the colorbar will be shown. By default, three levels will be labeled:
        0, the \code{min(x[[zInner]])} and \code{max(x[[zInner]])}.}
    \item{\code{hlines = TRUE}}{ Logical: whether black horizontal lines should be displayed in the colorbar to separate the colors. Defaults to TRUE. }
}}

\item{color.function}{A custom function that receives one argument (number of colors to be generated, (maxrank - minrank + 1) in our case) and returns a vector of that length
with the hexadecimal codes of the colors to be used in the heatmaps, see \code{heat.colors} or \code{terrain.colors} for instance. Defaults to the \code{heat.colors} function.}

\item{heatmaps.per.row}{Maximum number of heatmaps displayed in a row of the grid. Useful when variable \code{xOuter} has too many levels so they can be
splitted in two or more sub-rows of heatmaps, with all the sub-rows corresponding to a single level of the \code{yOuter} variable.}

\item{heatmaps.titles}{A vector of the same length as the total number of heatmaps, i.e. unique(x[[yOuter]]) * unique(x[[xOuter]]), containing the
titles to be displayed on top of each heatmap. The elements of the vector will be associated to the heatmaps of the grid from left to right and from top to bottom.}

\item{show.colorbar}{Logical: whether a colorbar legend will be shown on the right of the figure (one for each row of heatmaps) or not. Defaults to TRUE}

\item{annotation.lab}{String with the annotation title that will be displayer on the top left corner. Defaults to NULL, indicating no annotation will be shown.}

\item{heat.cell.par}{Tagged list that will be passed to \code{\link{par}} just before displaying each heatmap. This way expert users can configure exactly
the appearance of the heatmaps. No additional checks will be done concerning the validity of this list.}

\item{heat.axes.par}{Tagged list that will be passed to \code{\link{axis}} when creating the heatmap axes. No additional validity checks are done.
The values of the arguments \code{side, at, labels} will always be replaced by suitable ones according to \code{inner.X.par[["levels.at"]]} or \code{inner.Y.par[["levels.at"]]}.}

\item{colorbar.cell.par}{Tagged list that will be passed to \code{\link{par}} just before showing each colorbar. No additional validity checks are done.}

\item{colorbar.axes.par}{Tagged list that will be passed to \code{\link{axis}} to draw the axes of the colorbar. No additional validity checks are done.}

\item{annotation.text.par}{Tagged list that will be passed to \code{\link{text}} to show an additional title on the top left corner. No additional validity checks are done.}

\item{...}{(In \code{animatedplot}): Rest of optional parameters that will be passed to \code{\link{plot.SRCS}} to plot every frame.
(In \code{singleplot}): A number of named arguments of the form \code{variable = value}, where \code{variable} is a column in \code{x}, for subsetting
\code{x} in a way that there exists exactly one occurrence of all the levels of \code{zInner} for each combination of yInner,xInner.}

\item{filename}{Name of the output video file, including the extension. It is strongly recommended that the name ends in ".gif" to preserve most of image quality.}

\item{path.to.converter}{String with the full path to the converter program delivered with ImageMagick, e.g. "C:/Program Files/ImageMagick-<version>/convert.exe"}

\item{width,height}{Width and height, in pixels, of the result video. Both default to 800}

\item{res}{Nominal resolution (in ppi) of the output video. Used to set text size and line widths. Defaults to 100. See \code{\link{png}, \link{jpeg}, \link{bmp}, \link{tiff}}.}

\item{pointsize}{Point size argument to be passed to the functions that print to image. Defaults to 16.}

\item{delay}{Time delay (in 1/100th of a second) spent in each of the images that compose the video. Defaults to 30, i.e. 0.3 seconds.}

\item{type}{The type of image file generated for each frame. The image files will be then joined together into a video. Should be one of \code{"png", "jpeg", "bmp", "tiff"}.}

\item{quality}{The quality of the images, in a scale from 1 to 100. The less the quality, the more the compression and the smaller the file size.}

\item{compression}{(For TIFF format only) Used to indicate the kind of compression. Must be one of \code{"none", "rle", "lzw", "jpeg"}. Ignored if \code{type} is not \code{"tiff"}.}

\item{annotations}{Vector of strings with the annotation label of every image of the video. Should have the same length as \code{zInner}. Defaults to NULL (no annotations).}

\item{labels.par}{Tagged list to configure how the labels will be displayed:
\itemize{
    \item{\code{xlab    = TRUE}}{ Label with the name of the variable for the X axis. Will be displayed horizontally. Valid values:
        FALSE for no label; NULL or TRUE for the name of the outer variable; and any string for a specific label. Defaults to TRUE.}
    \item{\code{ylab    = TRUE}}{ Analogous for  the Y axis.}
    \item{\code{xlevels.at = NULL}}{ Levels of the X axis variable where the label will be shown. Defaults to all the levels.
        The levels can be provided in any order, since the order in which they will be depicted only depends on the original order defined
      when the corresponding factor column of the data was created.}
    \item{\code{ylevels.at = NULL}}{ Analogous for Y axis variable.}
}}

\item{haxis,vaxis}{Whether the X and the Y axes should be displayed or not. Defaults to TRUE for both.}

\item{title}{Title of the plot.}
}
\description{
\code{plot.SRCS}: Function to display a grid of heatmaps representing the statistical ranking of one level of the target factor (usually, the algorithm)
	vs the rest of levels of the target factor, over several problem configurations characterized by (at most) 3 parameters in addition to the target factor.

\code{animatedplot}: Function to generate an animated video consisting of a temporal sequence of grid plots like those generated by \code{\link{plot.SRCS}}.
	The function requires software ImageMagick has been installed.

\code{singleplot}: Function to display either a single heatmap representing the statistical ranking of one level of the target factor (usually, the algorithm)
	vs the rest of levels of the target factor, over one single problem configurations defined by a combination of values for the problem configuration parameters.
}
\details{
\code{plot.SRCS} plots a grid with the results over all problem configurations, and should be applied to the object returned by \code{\link{SRCSranks}} with
	only one \code{performance} column.

	\code{singleplot} is used for plotting only one heatmap for a subset of problem configurations
	in which the outer X and Y parameters take a fixed value, and should be applied to the object returned by \code{\link{SRCScomparison}}.

	\code{animatedplot} creates a video from a sequence of plots, intended to show the temporal evolution of the ranking over time.
	It should be applied only to the object returned by \code{\link{SRCSranks}} when the \code{performance} argument passed to it was a vector of strings,
	each of them being the performance column of the data at a given time instant.
}
\note{
The function uses the base graphics system.
}
\examples{
# Example from a Machine Learning problem with noisy data
	ranks = SRCSranks(ML1, params = c("Dataset", "Noise type", "Noise ratio"),
	  target = "Algorithm", performance="Performance", maximize = TRUE, ncores = 2,
	  paired = TRUE, pairing.col = "Fold");
	singleplot(ranks, yInner = "Noise type",
   xInner = "Noise ratio", Algorithm = "C4.5", Dataset = "glass")
	plot(x = ranks, yOuter = "Dataset", xOuter = "Algorithm", yInner = "Noise type",
	  xInner = "Noise ratio", out.X.par = list(levels.lab.textpar =
	  list(col = "white"), levels.bg = "black", levels.border = "white"),
	  out.Y.par = list(levels.bg = "gray"), colorbar.axes.par = list(cex.axis = 0.8),
	  show.colorbar = TRUE)
	SRCScomparison(ranks, "Algorithm", Dataset = "automobile", `Noise type` = "ATT_GAUS",
	  `Noise ratio`= 10, pvalues = FALSE)
# ---------------------------------------------------
\dontrun{
mat = matrix(NA, nrow = nrow(MPBall), ncol = ncol(MPBall))
# First, take the average of the previous performance columns up to each change point
for(j in 6:ncol(MPBall)){
  mat[,j] = rowSums(MPBall[,5:j])/(j-5+1)
}
MPBall[,6:ncol(MPBall)] = mat[,6:ncol(MPBall)]

ranksall = SRCSranks(MPBall, params = c("Dim", "CF", "Severity"), target="Algorithm",
   test = "tukeyHSD", performance=paste("OffError", seq(from=1, to = 100, by = 24),
   sep = "_"), maximize = FALSE, ncores = 2)

# Adjust argument path.to.converter to point to ImageMagick convert utility
animatedplot(x = ranksall, filename = "MPBconv_reduced.gif",
	             path.to.converter = "C:/Program Files/ImageMagick-6.8.8-Q8/convert.exe",
	             yOuter = "Algorithm", xOuter = "Dim", yInner = "CF", xInner = "Severity",
	             zInner = paste0("rank",1:5), delay = 30,
	             annotations = paste0("At change ",seq.int(from = 1, to = 100, by = 24)),
	             inner.Y.par = list(levels.at = c("40", "200", "400", "600", "800", "1000"),
              lab = "Change\\nfrequency", levels.loc = "left"),
	             heat.cell.par = list(pty = "s"),
	             inner.X.par = list(levels.at = c("2", "8", "14")),
	             out.Y.par = list(levels.lab.textpar = list(cex = 1, col = "white"),
              levels.bg = "black", levels.border = "white"),
	             out.X.par = list(lab = "Dimension", levels.bg = "gray"),
	             colorbar.par = list(levels.at = c("-2", "0", "2")),
	             colorbar.axes.par = list(cex.axis = 0.8),
	             show.colorbar = TRUE, height = 500
            )
# The full dataset (20 MB) can be downloaded from
# http://decsai.ugr.es/~pjvi/SRCSfiles/MPBall.RData
# (the average must still be computed before plotting, just as in the example above)
# Check the script in http://decsai.ugr.es/~pjvi/SRCSfiles/DOPvideoScript.R
}
}
\seealso{
\code{\link{text}, \link{par}, \link{axis}, \link{SRCSranks}, \link{animatedplot}, \link{singleplot}},
\link[RColorBrewer]{brewer.pal}, \link[colorspace]{RGB}
}

