% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/core.R
\name{SRCScomparison}
\alias{SRCScomparison}
\title{Compares the performance of two algorithms for a single problem configuration specified by the user.}
\usage{
SRCScomparison(rankdata, target, alpha = 0.05, pvalues = FALSE, ...)
}
\arguments{
\item{rankdata}{The ranks data frame obtained by a previous call to \code{\link{SRCSranks}}.}

\item{target}{Name of the target column in \code{rframe} that separates the levels to be compared, probably "Algorithm" or similar.}

\item{alpha}{Significance threshold to consider two set of measurements coming from two algorithms as statistically significant}

\item{pvalues}{Boolean. TRUE indicates that the pairwise comparison table should contain p-values.
FALSE means only ">","<" or "=" (the latter for non-significant difference) will be displayed in the table. Defaults to FALSE.}

\item{...}{The rest of the columns in \code{rframe} and the values to fully specify a single problem configuration for which algorithms will be compared.
Must be indicated as named arguments, like in "severity" = 4.}
}
\value{
A square matrix of the same dimension as algorithms found in the data. An entry i,j contains either the p-value of the Wilcoxon test between
	algorithms i and j (if \code{pvalues} was set to TRUE), or the qualitative result (">", "<" or "=") of the statistical comparison (if \code{pvalues} was set to FALSE).
}
\description{
Compares the performance of two algorithms for a single problem configuration specified by the user.
}
\seealso{
\code{\link{SRCSranks}, \link{plot.SRCS}} for a full working example of SRCScomparison.
}

