% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPSP.R
\name{SPSP_step}
\alias{SPSP_step}
\title{The selection step with the input of the solution paths.}
\usage{
SPSP_step(
  x,
  y,
  family = c("gaussian", "binomial"),
  BETA,
  standardize = TRUE,
  intercept = TRUE,
  init = 1,
  R = NULL,
  ...
)
}
\arguments{
\item{x}{independent variables as a matrix, of dimension nobs x nvars; each row is an observation vector.}

\item{y}{response variable. Quantitative for \code{family="gaussian"} or \code{family="poisson"} (non-negative counts). 
For \code{family="binomial"} should be either a factor with two levels.}

\item{family}{either a character string representing one of the built-in families, or else a glm() family object.}

\item{BETA}{the solution paths obtained from a prespecified fitting step \code{fitfun.SP = lasso.glmnet} etc. It must be 
a p by k matrix, should be thicker and thicker, each column corresponds to a lambda, and lambda gets smaller and smaller.
It is the returned coefficient matrix \code{beta} from a \code{glmnet} object, or a \code{ncvreg} object.}

\item{standardize}{whether need standardization.}

\item{intercept}{logical. If x is a data.frame, this argument determines if the resulting model matrix should contain 
a separate intercept or not.}

\item{init}{initial coefficients, starting from init-th estimator of the solution paths. The default is 1.}

\item{R}{sorted adjacent distances, default is NULL. Will be calculated inside.}

\item{...}{Additional optional arguments.}
}
\value{
A list containing at least the following components:
\item{\code{beta_SPSP}}{the estimated coefficients of SPSP selected model;}
\item{\code{S0}}{the estimated relevant sets;}
\item{\code{nonzero}}{the selected covariates;}
\item{\code{zero}}{the covariates that are not selected;}
\item{\code{thres}}{the boundaries for abs(beta);}
\item{\code{R}}{the sorted adjacent distances;}
\item{\code{intercept}}{the estimated intercept when \code{intercept == T}.}

This object has attribute contains: 

\item{\code{mod.fit}}{the fitted penalized regression within the input function \code{fitfun.SP};}
\item{\code{family}}{the family of fitted object;}
\item{\code{fitfun.SP}}{the function to obtain the solution paths for the SPSP algorithm;}
\item{\code{args.fitfun.SP}}{a named list containing additional arguments for the function \code{fitfun.SP}.}
}
\description{
A function to select the relevant predictors by partitioning the solution paths (the SPSP algorithm) 
based on the user provided solution paths \code{BETA}.
}
\examples{
data(HighDim)
library(glmnet)

x <- as.matrix(HighDim[,-1])
y <- HighDim[,1]

lasso_fit <- glmnet(x = x, y = y, alpha = 1, intercept = FALSE)

# SPSP+Lasso method
K <- dim(lasso_fit$beta)[2]
LBETA <- as.matrix(lasso_fit$beta)

spsp_lasso_1 <- SPSP_step(x = x, y = y, BETA = LBETA, 
                          init = 1, standardize = FALSE, intercept = FALSE)
head(spsp_lasso_1$nonzero)
head(spsp_lasso_1$beta_SPSP)

}
