% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features_11_incurred_history.R
\name{claim_history}
\alias{claim_history}
\title{Development of Case Estimates}
\usage{
claim_history(
  claims,
  majRev_list,
  minRev_list,
  k1 = 0.95,
  k2 = 0.95,
  base_inflation_vector = NULL,
  keep_all = FALSE
)
}
\arguments{
\item{claims}{an \code{claims} object containing all the simulated quantities
(other than those related to incurred loss), see
\code{\link[SynthETIC]{claims}}.}

\item{majRev_list}{nested list of major revision histories, see
\code{\link{claim_majRev}}.}

\item{minRev_list}{nested list of minor revision histories, see
\code{\link{claim_minRev}}.}

\item{k1}{maximum amount of cumulative claims paid as a proportion of
total incurred estimate for major revisions; between 0 and 1.}

\item{k2}{maximum amount of cumulative claims paid as a proportion of
total incurred estimate for minor revisions; between 0 and 1.}

\item{base_inflation_vector}{vector showing \strong{quarterly} base inflation
rates (quarterly effective) for all the periods under consideration (default
is nil base inflation), should be consistent with the input inflation vector
in \code{\link[SynthETIC]{claim_payment_inflation}}. If a single number is
provided, the function will assume constant quarterly inflation.}

\item{keep_all}{\code{TRUE} to keep the paid, outstanding payments, total
incurred estimates just before the revision, \code{FALSE} to keep only the
estimates right after the revision (\verb{_right}).}
}
\value{
A nested list structure such that the \emph{j}th component of the \emph{i}th
sub-list provides a full transactional history of the \emph{j}th claim of
occurrence period \emph{i}. The "unit list" (i.e. the smallest, innermost
sub-list) contains the following components:
\tabular{ll}{
\code{txn_delay} \tab Delays from notification to the transactions (payment or
incurred revision). \cr
\code{txn_time} \tab Times of the transactions (from the commencement of the
first occurrence period). \cr
\code{txn_type} \tab Types of the transactions, "Ma" for major revision, "Mi" for
minor revision, "P" for payment, "PMa" for major revision coincident with a
payment, "PMi" for minor revision coincident with a payment. \cr
\code{cumpaid_right} \tab Cumulative claim payments immediately after each of the
transactions (in the "right" continuous sense). \cr
\code{OCL_right} \tab Case estimate of outstanding claim payments immediately
after each of the transactions (in the "right" continuous sense). \cr
\code{incurred_right} \tab Case estimate of incurred loss immediately after each
of the transactions (in the "right" continuous sense). \cr
\code{minRev} \tab A list containing full history of minor revisions (frequency,
time and revision size); \code{\link{claim_minRev}}. \cr
\code{majRev} \tab A list containing full history of major revisions (frequency,
time and revision size); see \code{\link{claim_majRev}}.
}

and optionally (by setting \code{keep_all = TRUE}),
\tabular{ll}{
\code{cumpaid_left} \tab Cumulative claim payments just before each of the
transactions. \cr
\code{OCL_left} \tab Case estimate of outstanding claim payments just before each
of the transactions. \cr
\code{incurred_left} \tab Case estimate of incurred loss just before each of the
transactions. \cr
}
}
\description{
Consolidates payments and incurred revisions and returns a full transactional
history of all the individual claims (transaction being either a payment or
a case estimate revision).
}
\details{
This function works to generate the full history of claims paid and
incurred estimates by consolidating all the simulated revision quantities.
It should be noted that in this consolidation step, we make the following
adjustments:
\itemize{
\item Major and minor revisions should not occur simultaneously. In the event
that they do (which is only possible at the second last partial payment),
the major revision takes precedence, and the minor revision be discarded.
This will be reflected in the \code{majRev} and \code{minRev} components of the output
list.
\item Estimates of incurred loss are specified to be computed in reverse order,
and it is necessary that the total incurred estimate is always strictly
greater than the cumulative claims paid (except at the final paymen where
equality holds). Hence we introduce \code{k1} and \code{k2} to make sure that
the revised incurred estimates satisfy \deqn{ky(t) \ge c(t)} where \eqn{y(t)}
represents the total incurred estimate at delay \eqn{t}, \eqn{k} is a
constant between 0 and 1, and \eqn{c(t)} is the cumulative claims paid up to
time \eqn{t}. When the raw simulated revision multipliers violate this
requirement, the case estimates of the total incurred or the outstanding
claim payments will be increased to make sure this condition always holds,
i.e. this adjustment takes precedence over the raw simulated revision
multipliers.
\item \strong{Inflation adjustment}: One can choose to ignore inflation in the
incurred estimates (default), or to make allowance for
it.
\itemize{
\item If \code{base_inflation_vector == NULL} (default), then all case estimates
will be computed in values corresponding to time \eqn{t = 0}, i.e. the
commencement of the first occurrence period.
\item If \code{base_inflation_vector} is provided, then the case estimators will
include full superimposed inflation and base inflation only up to the date
of the revision, i.e. there is an adjustment for the time elapsed since the
immediately preceding revision and \strong{no future base inflation} beyond the
date of valuation.
\item If inflation is involved, it should be noted that the case estimator
reviews the base inflation situation only in the process of making a
revision. When \emph{only} a payment is made, the insurer's system automatically
writes down the outstanding liability on the assumption of no change in
ultimate incurred amount.
}
}
}
