% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_contribs.R
\name{vis_contribs}
\alias{vis_contribs}
\title{Visualise Contribution Matrix}
\arguments{
\item{contribs_mat}{Matrix of variable contributions. Must be of class \code{data.frame} with as many columns as the number of variables
and rows representing the observations.}

\item{subset}{Subset of observations for which the variable contribution matrix will be plotted.}

\item{scale}{Optional scaling parameter; defaults to "none" for no scaling. Possible options are "row", with each row being
divided by its sum or "max", where each element of the matrix is divided by the maximum element.}
}
\value{
Plot
}
\description{
Function producing a visualisation of the matrix of variable contributions. The user can choose to plot
just a subset of the data (for instance the outliers), as well as scale the scores if needed.
}
\examples{
\donttest{
dt <- as.data.frame(sample(c(1:2), 100, replace = TRUE, prob = c(0.5, 0.5)))
dt <- cbind(dt, sample(c(1:3), 100, replace = TRUE, prob = c(0.5, 0.3, 0.2)))
dt[, 1] <- as.factor(dt[, 1])
dt[, 2] <- as.factor(dt[, 2])
colnames(dt) <- c('V1', 'V2')
sono_out <- sono(data = dt,
probs = list(c(0.5, 0.5), c(1/3, 1/3, 1/3)),
alpha = 0.01,
r = 2,
MAXLEN = 0,
frequent = FALSE)
vis_contribs(contribs_mat = sono_out[[3]], subset = c(1:50), scale = "row")
}
}
