% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avg_rank_outs.R
\name{avg_rank_outs}
\alias{avg_rank_outs}
\title{Average Rank Of Outlier}
\usage{
avg_rank_outs(scores, outs, ties = "min")
}
\arguments{
\item{scores}{Scores of (nominal) outlyingness. A higher score here implies an observation is more likely to be an outlier.}

\item{outs}{Vector of outlier indices.}

\item{ties}{A character string specifying how ties in scores are treated; can be one of "average", "first", "last",
"random", "max" or "min".}
}
\value{
Average rank of outliers.
}
\description{
Function computing the average rank of the outliers given a vector with scores of outlyingness.
}
\examples{
dt <- as.data.frame(sample(c(1:2), 100, replace = TRUE, prob = c(0.5, 0.5)))
dt <- cbind(dt, sample(c(1:3), 100, replace = TRUE, prob = c(0.5, 0.3, 0.2)))
dt[, 1] <- as.factor(dt[, 1])
dt[, 2] <- as.factor(dt[, 2])
colnames(dt) <- c('V1', 'V2')
sono_out <- sono(data = dt, probs = list(c(0.5, 0.5), c(1/3, 1/3, 1/3)),
alpha = 0.01, r = 2, MAXLEN = 0, frequent = FALSE)
# Suppose observations 1 up to 5 are outliers
avg_rank_outs(scores = sono_out[[2]][, 2], outs = c(1:5), ties = "min")

}
