% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastphase.R
\name{writeXtoInp}
\alias{writeXtoInp}
\title{Convert genotypes X into the fastPHASE input format}
\usage{
writeXtoInp(X, phased = FALSE, out_file = NULL)
}
\arguments{
\item{X}{either a matrix of size n-by-p containing unphased genotypes for n individuals,
or a matrix of size 2n-by-p containing phased haplotypes for n individuals.}

\item{phased}{whether the data are phased (default: FALSE).
If this is equal to TRUE, each pair of consecutive rows will be assumed to correspond to phased haplotypes from the
same individual.}

\item{out_file}{a string containing the path of the output file onto which X will be written (default: NULL).
If this is equal to NULL, a temporary file in the R temporary directory will be used.}
}
\value{
A string containing the path of the output file onto which X was written. This is useful to find the data
when the default option for `out_file` is used and X is written onto a temporary file in the R temporary directory.
}
\description{
This function converts a genetic matrix X into the fastPHASE input format and saves
it to a user-specified file. Then, an HMM can be fitted by calling fastPHASE with
\link{runFastPhase}.
}
\examples{
# Convert unphased genotypes
# Load an example data matrix X from the package installation directory.
X_file = system.file("extdata", "genotypes.RData", package = "SNPknock")
load(X_file)
# Write X in a temporary file
Xinp_file = writeXtoInp(X)

# Convert phased haplotypes
# Load an example data matrix H from the package installation directory.
H_file = system.file("extdata", "haplotypes.RData", package = "SNPknock")
load(H_file)
# Write H in a temporary file
Hinp_file = writeXtoInp(H, phased=TRUE)

}
\references{
\insertRef{scheet2006}{SNPknock}
}
\seealso{
Other fastPHASE: \code{\link{loadHMM}},
  \code{\link{runFastPhase}}
}
\concept{fastPHASE}
