% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastphase.R
\name{loadHMM}
\alias{loadHMM}
\title{Load HMM parameters fitted by fastPHASE}
\usage{
loadHMM(r_file, alpha_file, theta_file, char_file, compact = TRUE,
  phased = FALSE)
}
\arguments{
\item{r_file}{a string with the path of the "_rhat.txt" file produced by fastPHASE.}

\item{alpha_file}{a string with the path of the "_alphahat.txt" file produced by fastPHASE.}

\item{theta_file}{a string with the path of the "_thetahat.txt" file produced by fastPHASE.}

\item{char_file}{a string with the path of the "_origchars" file produced by fastPHASE.}

\item{compact}{whether to assemble the explicit transition and emission matrices for the HMM (default: FALSE).}

\item{phased}{whether to assemble a model for phased haplotypes, if compact==FALSE (default: FALSE).}
}
\value{
A structure containing the parameters from the Li and Stephens HMM for phased haplotypes.
}
\description{
This function loads the parameter estimates obtained by fastPHASE (see \link{runFastPhase})
and assembles the Li and Stephens HMM, in the format required by the knockoff generation functions
\link{knockoffHaplotypes} and \link{knockoffGenotypes}.
}
\details{
This function by default returns a structure with three fields:
\itemize{
  \item{"r": a numerical array of length p.}
  \item{"alpha": a numerical array of size (p,K).}
  \item{"theta": a numerical array of size (p,K).}
 }

If the parameter compact is FALSE, this function assembles the HMM model for the genotype data
(either unphased or phased), in the format required by the knockoff generation function \link{knockoffHMM}.
}
\examples{
# Specify the location of the fastPHASE output files containing the parameter estimates.
# Example files can be found in the package installation directory.
r_file = system.file("extdata", "genotypes_rhat.txt", package = "SNPknock")
alpha_file = system.file("extdata", "genotypes_alphahat.txt", package = "SNPknock")
theta_file = system.file("extdata", "genotypes_thetahat.txt", package = "SNPknock")
char_file = system.file("extdata", "genotypes_origchars", package = "SNPknock")

# Read the parameter files and load the HMM
hmm = loadHMM(r_file, alpha_file, theta_file, char_file)

# Read the parameter files and load the HMM
hmm.large = loadHMM(r_file, alpha_file, theta_file, char_file, compact=FALSE)

}
\references{
\insertRef{scheet2006}{SNPknock}
}
\seealso{
Other fastPHASE: \code{\link{runFastPhase}},
  \code{\link{writeXtoInp}}
}
\concept{fastPHASE}
