% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SMMAL.R
\name{SMMAL}
\alias{SMMAL}
\title{Estimate Average Treatment Effect (ATE) via Semi-Supervised Learning Pipeline}
\usage{
SMMAL(Y, A, S, X, nfold = 5, cf_model = "bspline", custom_model_fun = NULL)
}
\arguments{
\item{Y}{Numeric vector. Outcome variable (may contain \code{NA} for unlabelled observations).}

\item{A}{Numeric vector. Treatment indicator (1 = treated, 0 = control). May contain \code{NA} for unlabelled observations.}

\item{S}{Matrix or data frame. Surrogate variables used only in imputation models.}

\item{X}{Matrix or data frame. Main covariates used for outcome and propensity score modeling.}

\item{nfold}{Integer. Number of cross-validation folds. Default is 5.}

\item{cf_model}{Character string. Modeling method to use in cross-fitting. One of \code{"bspline"}, \code{"xgboost"}, or \code{"randomforest"}. Default is "bspline".}

\item{custom_model_fun}{A logical or function. If \code{NULL} or \code{FALSE}, bypasses adaptive-LASSO feature selection. Otherwise, enables two-stage tuning inside \code{compute_parameter()}.}
}
\value{
A list containing:
\describe{
\item{est}{Estimated Average Treatment Effect (ATE).}
\item{se}{Estimated standard error of the ATE.}
}
}
\description{
Executes a full semi-supervised ATE estimation pipeline. This includes cross-validation
fold assignment, feature selection via adaptive LASSO, model fitting using a specified learner
(e.g., bspline, xgboost, or random forest), and doubly robust ATE estimation
that leverages both labelled and unlabelled data.
}
\details{
The pipeline first selects important covariates via adaptive LASSO. Then, it fits nuisance functions
(outcome regressions and propensity scores) using cross-fitting with the specified learner.
Finally, it applies a doubly robust estimator that integrates information from both labelled and
unlabelled observations to estimate the ATE.
}
\seealso{
\code{\link{cf}}, \code{\link{compute_parameter}}, \code{\link{cross_validation}}, \code{\link{ate.SSL}}
}
