% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.R
\docType{data}
\name{Election1982}
\alias{Election1982}
\title{Presidential Election 1982}
\format{
A data frame with 6 columns and 2018 rows.
\describe{
\item{\code{Year}}{Year of the presidential election}
\item{\code{District}}{District Names}
\item{\code{Electorate}}{Electorate Names, Postal District Votes and Final District Results}
\item{\code{ColNames}}{Candidate Names, Total No of Valid Votes, No of Rejected Votes, Total No of Votes Polled and No of Registered Electors}
\item{\code{Votes}}{No of votes for the ColNames variable}
\item{\code{Percentage}}{Percentage of votes with regard to the No of Registered Electors and the Total No of Votes Polled for Total No of Votes Polled and all other ColNames variable, respectively}
}
}
\source{
Extracted from the pdf published by the Sri Lankan Elections commission at
\url{https://elections.gov.lk}
or the project that I have completed in scraping the data from the pdf file at :
\url{https://github.com/Amalan-ConStat/PresidentialElection}.
}
\usage{
data(Election1982)
}
\description{
The first presidential election of Sri Lanka was held in 1982. Its results are published
as a pdf file. The data available in this file is scraped and summarised as a data-frame Election1982.
}
\details{
There are 22 districts and 160 electorates in Sri Lanka. In 1982 six candidates participated in this election and J.R. Jayawardene
became the first executive president.
}
\examples{
Election1982[Election1982$District == "Colombo" & Election1982$Electorate == "Colombo-North",]

}
\keyword{datasets}
