% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_indices.R
\name{generate_indices}
\alias{generate_indices}
\title{Generate a test array of Glass-Fragment Refractive Indices.}
\usage{
generate_indices(n = 10, .sd_multi = 1)
}
\arguments{
\item{n}{Number of refractive indices to generate.}

\item{.sd_multi}{Scale factor of the standard deviation. Greater values imply more variance in the random sample.}
}
\value{
A vector of randomly generated RIs.
}
\description{
Returns a vector of randomly generated refractive indices from a expected normal distribution of glass fragments.
}
\examples{

test_ris = generate_indices(8)
partition(test_ris)

test_ris_varied = generate_indices(.sd_multi = 5)
partition(test_ris_varied)

}
