% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.SIR_threshold_bootstrap.R
\name{plot.SIR_threshold_bootstrap}
\alias{plot.SIR_threshold_bootstrap}
\title{Graphical output of SIR_threshold_bootstrap}
\usage{
\method{plot}{SIR_threshold_bootstrap}(x, choice = "", ...)
}
\arguments{
\item{x}{A SIR_threshold_bootstrap object}

\item{choice}{the graph to plot: 
\itemize{
  \item "estim_ind" Plot the estimated index by the SIR model versus Y.
  \item "size" Plot the size of the models across the replications.
  \item "selec_var" Plot the occurrence of the selected variables across the replications.
  \item "coefs_b" Plot the value of \eqn{\hat{b}} across the replications.
  \item "lambdas_replic" Plot the distribution of \eqn{\lambda_{opt}} across the replications.
  \item "" Plot every graphs (default).
}}

\item{\ldots}{arguments to be passed to methods, such as graphical parameters (not used here).}
}
\value{
No return value
}
\description{
Display the estimated index versus Y of the SIR model, the size of the models,
the occurrence of variable selection, the distribution of the coefficients of  
and \eqn{\hat{b}} and the distribution of \eqn{\lambda_{opt}} found across the replications.
}
\examples{
# Generate Data
set.seed(10)
n <- 200
beta <- c(1,1,rep(0,8))
X <- mvtnorm::rmvnorm(n,sigma=diag(1,10))
eps <- rnorm(n)
Y <- (X\%*\%beta)**3+eps

\donttest{
res = SIR_threshold_bootstrap(Y,X,H=10,n_lambda=300,thresholding="hard", n_replications=30,k=2)

# Estimated index versus Y
plot(res,choice="estim_ind")

# Model size
plot(res,choice="size")

# Selected variables
plot(res,choice="selec_var")

# Coefficients of b
plot(res,choice="coefs_b")

# Optimal lambdas
plot(res,choice="lambdas_replic")
}
}
