% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Method_function.R
\name{SCAR}
\alias{SCAR}
\title{Standard Center Augmented Regularization (S-CAR) Method for Subgroup Identification and Variable Selection}
\usage{
SCAR(Y, X, lam_CAR, lam_lasso, alpha_init, K, epsilon)
}
\arguments{
\item{Y}{The response vector of length \eqn{n}.}

\item{X}{The design matrix of size \eqn{n \times p}.}

\item{lam_CAR}{The tuning parameter for Center-Augmented Regularization.}

\item{lam_lasso}{The tuning parameter for lasso.}

\item{alpha_init}{The initialization of intercept parameter.}

\item{K}{The estimated group number.}

\item{epsilon}{The user-supplied stopping tolerance.}
}
\value{
A list with the following components:
\item{alpha_m}{The estimated intercept parameter vector of length \eqn{n}.}
\item{gamma}{The estimated vector of subgroup centers of length \eqn{K}.}
\item{beta_m}{The estimated regression coefficient vector of dimension \eqn{p}.}
}
\description{
This function employs the S-CAR method under L2 distance and uses the Coordinate Descent Algorithm for optimization to identify subgroup structures and execute variable selection.
}
\examples{
n <- 50
p <- 50
r <- 3
K <- 2
alpha <- sample(c(-3,3),n,replace=TRUE,prob=c(1/2,1/2))
beta <- c(rep(1,2),rep(0,48))
B <- matrix((rnorm(p*r,1,1)),p,r)
F_1 <- matrix((rnorm(n*r,0,1)),n,r)
U <- matrix(rnorm(p*n,0,0.1),n,p)
X <- F_1\%*\%t(B)+U
Y <- alpha + X\%*\%beta + rnorm(n,0,0.5)
alpha_init <- INIT(Y,X,0.1)
SCAR(Y,X,0.01,0.05,alpha_init,K,0.3)
}
\author{
Yong He, Liu Dong, Fuxin Wang, Mingjuan Zhang, Wenxin Zhou.
}
