% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Method_function.R
\name{FA_PFP}
\alias{FA_PFP}
\title{Factor Adjusted-Pairwise Fusion Penalty (FA-PFP) Method for Subgroup Identification and Variable Selection}
\usage{
FA_PFP(Y, Fhat, Uhat, vartheta, lam, gam, alpha_init, lam_lasso, epsilon)
}
\arguments{
\item{Y}{The response vector of length \eqn{n}.}

\item{Fhat}{The estimated common factors matrix of size \eqn{n \times r}.}

\item{Uhat}{The estimated idiosyncratic factors matrix of size \eqn{n \times p}.}

\item{vartheta}{The Lagrangian augmentation parameter for intercepts.}

\item{lam}{The tuning parameter for Pairwise Fusion Penalty.}

\item{gam}{The user-supplied parameter for Alternating Direction Method of Multipliers (ADMM) algorithm.}

\item{alpha_init}{The initialization of intercept parameter.}

\item{lam_lasso}{The tuning parameter for LASSO.}

\item{epsilon}{The user-supplied stopping tolerance.}
}
\value{
A list with the following components:
\item{alpha_m}{The estimated intercept parameter vector of length \eqn{n}.}
\item{theta_m}{The estimated regression coefficient vector, matched with common factor terms, with a dimension of \eqn{r}.}
\item{beta_m}{The estimated regression coefficients matched with idiosyncratic factors, with a dimension of \eqn{p}.}
\item{eta_m}{A numeric matrix storing the pairwise differences of the estimated intercepts, with size of \eqn{n \times (n\times(n-1)/2)}.}
}
\description{
This function utilizes the FA-PFP method implemented via the Alternating Direction Method of Multipliers (ADMM) algorithm to identify subgroup structures and conduct variable selection.
}
\examples{
n <- 50
p <- 50
r <- 3
alpha <- sample(c(-3,3),n,replace=TRUE,prob=c(1/2,1/2))
beta <- c(rep(1,2),rep(0,48))
B <- matrix((rnorm(p*r,1,1)),p,r)
F_1 <- matrix((rnorm(n*r,0,1)),n,r)
U <- matrix(rnorm(p*n,0,0.1),n,p)
X <- F_1\%*\%t(B)+U
Y <- alpha + X\%*\%beta + rnorm(n,0,0.5)
alpha_init <- INIT(Y,F_1,0.1)
FA_PFP(Y,F_1,U,1,0.67,3,alpha_init,0.05,0.3)
}
\references{
Ma, S., Huang, J., 2017. A concave pairwise fusion approach to subgroup analysis.
}
\author{
Yong He, Liu Dong, Fuxin Wang, Mingjuan Zhang, Wenxin Zhou.
}
