% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vark_1937Bartlett.R
\name{vark.1937Bartlett}
\alias{vark.1937Bartlett}
\title{Bartlett's Test for Homogeneity of Variance}
\usage{
vark.1937Bartlett(dlist)
}
\arguments{
\item{dlist}{a list of length \eqn{k} where each element is a sample vector.}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value under \eqn{H_0}.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
Given univariate samples \eqn{X_1~,\ldots,~X_k}, it tests
\deqn{H_0 : \sigma_1^2 = \cdots \sigma_k^2\quad vs\quad H_1 : \textrm{at least one equality does not hold}}
using the procedure by Bartlett (1937).
}
\examples{
## CRAN-purpose small example
small1d = list()
for (i in 1:5){ # k=5 sample
  small1d[[i]] = rnorm(20)
}
vark.1937Bartlett(small1d) # run the test

\donttest{
## test when k=5 (samples)
## empirical Type 1 error 
niter   = 1000
counter = rep(0,niter)  # record p-values
for (i in 1:niter){
  mylist = list()
  for (j in 1:5){
     mylist[[j]] = rnorm(50)   
  }
  
  counter[i] = ifelse(vark.1937Bartlett(mylist)$p.value < 0.05, 1, 0)
}

## print the result
cat(paste("\n* Example for 'vark.1937Bartlett'\n","*\n",
"* number of rejections   : ", sum(counter),"\n",
"* total number of trials : ", niter,"\n",
"* empirical Type 1 error : ",round(sum(counter/niter),5),"\n",sep=""))
}

}
\references{
\insertRef{bartlett_properties_1937}{SHT}
}
\concept{variance}
