% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim1_2017Liu.R
\name{sim1.2017Liu}
\alias{sim1.2017Liu}
\title{One-sample Simultaneous Test of Mean and Covariance by Liu et al. (2017)}
\usage{
sim1.2017Liu(X, mu0 = rep(0, ncol(X)), Sigma0 = diag(ncol(X)))
}
\arguments{
\item{X}{an \eqn{(n\times p)} data matrix where each row is an observation.}

\item{mu0}{a length-\eqn{p} mean vector of interest.}

\item{Sigma0}{a \eqn{(p\times p)} given covariance matrix.}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value under \eqn{H_0}.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
Given a multivariate sample \eqn{X}, hypothesized mean \eqn{\mu_0} and covariance \eqn{\Sigma_0}, it tests
\deqn{H_0 : \mu_x = \mu_0 \textrm{ and } \Sigma_x = \Sigma_0 \quad vs\quad H_1 : \textrm{ not } H_0}
using the procedure by Liu et al. (2017).
}
\examples{
## CRAN-purpose small example
smallX = matrix(rnorm(10*3),ncol=3)
sim1.2017Liu(smallX) # run the test

\dontrun{
## empirical Type 1 error 
niter   = 1000
counter = rep(0,niter)  # record p-values
for (i in 1:niter){
  X = matrix(rnorm(50*10), ncol=10)
  counter[i] = ifelse(sim1.2017Liu(X)$p.value < 0.05, 1, 0)
}

## print the result
cat(paste("\n* Example for 'sim1.2017Liu'\n","*\n",
"* number of rejections   : ", sum(counter),"\n",
"* total number of trials : ", niter,"\n",
"* empirical Type 1 error : ",round(sum(counter/niter),5),"\n",sep=""))
}

}
\references{
\insertRef{liu_simultaneous_2017}{SHT}
}
\concept{simtest}
