% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean2_2011LJW.R
\name{mean2.2011LJW}
\alias{mean2.2011LJW}
\title{Two-sample Test for Multivariate Means by Lopes, Jacob, and Wainwright (2011)}
\usage{
mean2.2011LJW(X, Y, method = c("asymptotic", "MC"), nreps = 1000)
}
\arguments{
\item{X}{an \eqn{(n_x \times p)} data matrix of 1st sample.}

\item{Y}{an \eqn{(n_y \times p)} data matrix of 2nd sample.}

\item{method}{method to compute \eqn{p}-value. \code{"asymptotic"} for using approximating null distribution, 
and \code{"MC"} for random permutation tests. Using initials is possible, \code{"a"} for asymptotic for example.}

\item{nreps}{the number of permutation iterations to be run when \code{method="MC"}.}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value under \eqn{H_0}.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
Given two multivariate data \eqn{X} and \eqn{Y} of same dimension, it tests
\deqn{H_0 : \mu_x = \mu_y\quad vs\quad H_1 : \mu_x \neq \mu_y}
using the procedure by Lopes, Jacob, and Wainwright (2011) using random projection. 
Due to solving system of linear equations, we suggest you to opt for asymptotic-based 
\eqn{p}-value computation unless truly necessary for random permutation tests.
}
\examples{
## CRAN-purpose small example
smallX = matrix(rnorm(10*3),ncol=10)
smallY = matrix(rnorm(10*3),ncol=10)
mean2.2011LJW(smallX, smallY) # run the test

\donttest{
## empirical Type 1 error 
niter   = 1000
counter = rep(0,niter)  # record p-values
for (i in 1:niter){
  X = matrix(rnorm(10*20), ncol=20)
  Y = matrix(rnorm(10*20), ncol=20)
  
  counter[i] = ifelse(mean2.2011LJW(X,Y)$p.value < 0.05, 1, 0)
}

## print the result
cat(paste("\n* Example for 'mean2.2011LJW'\n","*\n",
"* number of rejections   : ", sum(counter),"\n",
"* total number of trials : ", niter,"\n",
"* empirical Type 1 error : ",round(sum(counter/niter),5),"\n",sep=""))
}

}
\references{
\insertRef{lopes_more_2011}{SHT}
}
\concept{mean_multivariate}
