% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgdi_lm.R
\name{sgdi_lm}
\alias{sgdi_lm}
\title{Averaged SGD and its Inference via Random Scaling}
\usage{
sgdi_lm(
  formula,
  data,
  gamma_0 = NULL,
  alpha = 0.501,
  burn = 1,
  inference = "rs",
  bt_start = NULL,
  studentize = TRUE,
  no_studentize = 100L,
  intercept = TRUE,
  rss_idx = c(1),
  level = 0.95,
  path = FALSE,
  path_index = c(1)
)
}
\arguments{
\item{formula}{formula. The response is on the left of a ~ operator. The terms are on the right of a ~ operator, separated by a + operator.}

\item{data}{an optional data frame containing variables in the model.}

\item{gamma_0}{numeric. A tuning parameter for the learning rate (gamma_0 x t ^ alpha). Default is NULL and it is determined by the adaptive method: 1/sd(y).}

\item{alpha}{numeric. A tuning parameter for the learning rate (gamma_0 x t ^ alpha). Default is 0.501.}

\item{burn}{numeric. A tuning parameter for "burn-in" observations. We burn-in up to (burn-1) observations and use observations from (burn) for estimation. Default is 1, i.e. no burn-in.}

\item{inference}{character. Specifying the inference method. Default is "rs" (random scaling matrix for joint inference using all the parameters). 
"rss" is for ransom scaling subset inference. This option requires that "rss_indx" should be provided.
"rsd" is for the diagonal elements of the random scaling matrix, excluding one for the intercept term.}

\item{bt_start}{numeric. (p x 1) vector. User-provided starting value Default is NULL.}

\item{studentize}{logical. Studentize regressors. Default is TRUE}

\item{no_studentize}{numeric. The number of observations to compute the mean and std error for studentization. Default is 100.}

\item{intercept}{logical. Use the intercept term for regressors. Default is TRUE. 
If this option is TRUE, the first element of the parameter vector is the intercept term.}

\item{rss_idx}{numeric. Index of x for random scaling subset inference. Default is 1, the first regressor of x. 
For example, if we want to focus on the 1st and 3rd covariates of x, then set it to be c(1,3).}

\item{level}{numeric. The confidence level required. Default is 0.95. Can choose 0.90 and 0.80.}

\item{path}{logical. The whole path of estimation results is out. Default is FALSE.}

\item{path_index}{numeric. A vector of indices to print out the path. Default is 1.}
}
\value{
An object of class \code{"sgdi"}, which is a list containing the following
\describe{
\item{\code{coefficient}}{A (p + 1)-vector of estimated parameter values including the intercept.}
\item{\code{var}}{A (p+1)x (p+1) variance-covariance matrix of \code{coefficient}}
\item{\code{ci.lower}}{The lower part of the 95\% confidence interval}
\item{\code{ci.upper}}{The upper part of the 95\% confidence interval}
\item{\code{level}}{The confidence level required. Default is 0.95.}
\item{\code{path_coefficients}}{The path of coefficients.}
}
}
\description{
Compute the averaged SGD estimator and conduct inference via random scaling method.
}
\examples{
n = 1e05
p = 5
bt0 = rep(5,p)
x = matrix(rnorm(n*(p-1)), n, (p-1))
y = cbind(1,x) \%*\% bt0 + rnorm(n)
my.dat = data.frame(y=y, x=x)
sgdi.out = sgdi_lm(y~., data=my.dat)
}
