% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_bulk.R
\name{compute_metrics}
\alias{compute_metrics}
\title{Statistical evaluations of predicted cell proportions}
\usage{
compute_metrics(prop_pred, prop_sim)
}
\arguments{
\item{prop_pred}{a matrix-like object of predicted cell proportion values with rows representing cell types, columns representing samples.}

\item{prop_sim}{a matrix-like object of simulated/expected cell proportion values with rows representing cell types, columns representing samples.}
}
\value{
a list of two objects:
\enumerate{
 \item a data.fame of summary metrics containing RMSE, bias & variance grouped by cell types and mixture ids (simulated samples with the same expected cell proportions).
 \item a data.frame of aggregated RMSE values across all cell types within each sample.
}
}
\description{
Compute RMSE, bias & variance metrics for predicted cell proportions by comparing with expected cell proportions.
}
\examples{
\donttest{
## generate artificial bulk samples
ref_list <- c(paste0(system.file("extdata", package = "SCdeconR"), "/refdata/sample1"),
              paste0(system.file("extdata", package = "SCdeconR"), "/refdata/sample2"))
phenopath1 <- paste0(system.file("extdata", package = "SCdeconR"),
"/refdata/phenodata_sample1.txt")
phenopath2 <- paste0(system.file("extdata", package = "SCdeconR"),
"/refdata/phenodata_sample2.txt")
phenodata_list <- c(phenopath1,phenopath2)

# construct integrated reference using harmony algorithm
refdata <- construct_ref(ref_list = ref_list,
                      phenodata_list = phenodata_list,
                      data_type = "cellranger",
                      method = "harmony",
                      group_var = "subjectid",
                      nfeature_rna = 50,
                      vars_to_regress = "percent_mt", verbose = FALSE)
phenodata <- data.frame(cellid = colnames(refdata),
                        celltypes = refdata$celltype,
                        subjectid = refdata$subjectid)
prop <- data.frame(celltypes = unique(refdata$celltype), 
proportion = rep(1/length(unique(refdata$celltype)), length(unique(refdata$celltype))))                        
bulk_sim <- bulk_generator(ref = GetAssayData(refdata, slot = "data", assay = "SCT"),
                           phenodata = phenodata,
                           num_mixtures = 20,
                           prop = prop,
                           num_mixtures_sprop = 1)

## perform deconvolution based on "OLS" algorithm
decon_res <- scdecon(bulk = bulk_sim[[1]],
                     ref = GetAssayData(refdata, slot = "data", assay = "SCT"),
                     phenodata = phenodata,
                     filter_ref = TRUE,
                     decon_method = "OLS",
                     norm_method_sc = "LogNormalize",
                     norm_method_bulk = "TMM",
                     trans_method_sc = "none",
                     trans_method_bulk = "log2",
                     marker_strategy = "all")

## compute metrics
metrics_res <- compute_metrics(decon_res[[1]], bulk_sim[[2]])
}
}
