% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway_analysis.R
\name{comparegsea_scatter}
\alias{comparegsea_scatter}
\title{Generate a scatter plot comparing two gene set enrichment analysis results}
\usage{
comparegsea_scatter(
  gseares_path1,
  gseares_path2,
  result_names = NULL,
  nes_cutoff = 2,
  pval_cutoff = 0.1,
  pvalflag = TRUE,
  interactive = FALSE
)
}
\arguments{
\item{gseares_path1}{path to GSEA output.}

\item{gseares_path2}{path to a second GSEA output.}

\item{result_names}{a vector of length 2 indicating the names of the two GSEA results. If NULL, names will be set to c("results1", "results2")}

\item{nes_cutoff}{normalized enrichment score cutoff to identify enriched gene-sets.}

\item{pval_cutoff}{p value cutoff to identify enriched gene-sets.}

\item{pvalflag}{a logical value indicating whether to use adjusted p value in selecting enriched gene-sets. Default to TRUE.}

\item{interactive}{a logical value indicating whether to generate an interactive plot. Default to FALSE.}
}
\value{
a \code{ggplot} object or \code{plotly} object if interactive is set to TRUE
}
\description{
Generate a scatter plot of normalized enrichment scores comparing two results for gene set enrichment analysis, e.g. w/wo adjusting for cell proportion differences.
}
\details{
this function does not support output from GSEA \href{https://github.com/GSEA-MSigDB/GSEA_R}{R implementation}
}
