% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpatReg_PseudoR2.R
\name{SpatReg_PseudoR2}
\alias{SpatReg_PseudoR2}
\title{Computes the Pseudo R\eqn{^2} metric for a given spatial regression model of class \code{lm} or \code{Sarlm}.}
\usage{
SpatReg_PseudoR2(SRModel)
}
\arguments{
\item{SRModel}{Estimated spatial or non-spatial regression model of class \code{lm} or \code{Sarlm} (see package \code{spatialreg} for details.)}
}
\value{
A \code{numeric} value reporting the Pseudo R\eqn{^2} for the input model in \code{SRModel}.
}
\description{
Computes the Pseudo R\eqn{^2} metric for a given spatial regression model of class \code{lm} or \code{Sarlm} as defined in package \code{spatialreg}.
The function can be applied to the output of any SCSR model and contained in the \code{ClusterFitModels} output of \code{SCSR_Estim} function.
}
\examples{
data(Data_RC_PM_RM_JABES2024, package="SCDA")
SCSAR <- SCSR_Estim(Formula = "Gini_SO ~ GDPPC_PPS2020 + Share_AgroEmp",
                    Data_sf = Data2020, G=3, listW=listW, Type="SCSAR", Phi = 0.50)
SpatReg_PseudoR2(SRModel = SCSAR$ClusterFitModels[[1]])
SpatReg_PseudoR2(SRModel = SCSAR$ClusterFitModels[[2]])
SpatReg_PseudoR2(SRModel = SCSAR$ClusterFitModels[[3]])

}
