% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parammod.R
\name{param_gamma}
\alias{param_gamma}
\title{Gamma parameter model}
\usage{
param_gamma(a0, a1, b0, b1)
}
\arguments{
\item{a0}{\code{theta_0 ~ Gamma(a0,a1)}}

\item{a1}{\code{theta_0 ~ Gamma(a0,a1)}}

\item{b0}{\code{theta_k ~ Gamma(b0,b1)}}

\item{b1}{\code{theta_k ~ Gamma(b0,b1)}}
}
\value{
a \code{parammod}
}
\description{
A \code{parammod} with gamma-distributed parameters
}
\details{
This model represents a prior on theta with:
\deqn{theta_0 ~ Gamma(a0,a1)}
\deqn{theta_k ~ Gamma(b0,b1)} for k = 1 ... kappa
}
\examples{
## theta0 ~ Gamma(1,1); thetak ~ Gamma(5,5)
pg <- param_gamma(1,1,5,5)
pg$r(5) ## a draw with 5 within-block parameters
}
