% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blockmod.R
\name{crp}
\alias{crp}
\title{Chinese Restaurant Process}
\usage{
crp(gamma)
}
\arguments{
\item{gamma}{concentration parameter}
}
\value{
a block model representing a \code{CRP(gamma)} distribution
}
\description{
A \code{\link{blockmod}} for the Chinese restaurant process (CRP)
}
\details{
The CRP posits that each node arrives in turn. The first node joins the first block. Each subsequent node starts a new block with probability `gamma` or joins an existing block proportional to the block size.
}
\examples{
## simulate from a CRP(5) prior
m <- crp(5)
print(m)
m$r(10)
}
