% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.manhattan.R
\name{manhattan}
\alias{manhattan}
\title{Manhattan distance}
\usage{
manhattan(X, Y)
}
\arguments{
\item{X}{[matrix or SparseHist] If matrix, dim = ( nrow = n_samples, ncol =
n_features)}

\item{Y}{[matrix or SparseHist] If matrix, dim = ( nrow = n_samples, ncol =
n_features)}
}
\value{
[float] value of distance
}
\description{
Compute Manhattan distance between two dataset or SparseHist X and Y
}
\examples{
X = base::cbind( stats::rnorm(2000) , stats::rnorm(2000)  )
Y = base::cbind( stats::rnorm(2000,mean=2)  , stats::rnorm(2000) )
bw = base::c(0.1,0.1)
muX = SBCK::SparseHist( X , bw )
muY = SBCK::SparseHist( Y , bw )

## The four are equals
d = SBCK::manhattan(  X ,   Y )
d = SBCK::manhattan(muX ,   Y )
d = SBCK::manhattan(  X , muY )
d = SBCK::manhattan(muX , muY )

}
