% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_estimate.R
\name{calc.estimate}
\alias{calc.estimate}
\alias{calc.estimate.mean}
\alias{calc.estimate.null}
\title{Calculate estimate}
\usage{
calc.estimate(
  x,
  x.est,
  cutoff = 0,
  coefs = NULL,
  sf,
  scale.sf,
  pred.gene.names,
  pred.cells,
  null.model,
  nworkers,
  calc.maxcor,
  estimates.only
)

calc.estimate.mean(x, sf, scale.sf, mu, nworkers, estimates.only)

calc.estimate.null(x, sf, scale.sf, nworkers, estimates.only)
}
\arguments{
\item{x}{An expression count matrix. The rows correspond to genes and
the columns correspond to cells.}

\item{x.est}{The log-normalized predictor matrix. The rows correspond to
cells and the columns correspond to genes.}

\item{cutoff}{Maximum absolute correlation to determine whether a gene
should be predicted.}

\item{coefs}{Coefficients of a linear fit of log-squared ratio of
largest lambda to lambda of lowest cross-validation error. Used to estimate
model with lowest cross-validation error.}

\item{sf}{Normalized size factor.}

\item{scale.sf}{Scale of size factor.}

\item{pred.gene.names}{Names of genes to perform regression prediction.}

\item{pred.cells}{Index of cells to perform regression prediction.}

\item{null.model}{Whether to use mean gene expression as prediction.}

\item{nworkers}{Number of cores registered to parallel backend.}

\item{calc.maxcor}{Whether to calculate maximum absolute correlation.}

\item{estimates.only}{Only return SAVER estimates. Default is FALSE.}

\item{mu}{Matrix of prior means}
}
\value{
A list with the following components
\item{\code{est}}{Recovered (normalized) expression}
\item{\code{se}}{Standard error of estimates}
\item{\code{maxcor}}{Maximum absolute correlation for each gene. 2 if not
calculated}
\item{\code{lambda.max}}{Smallest value of lambda which gives the null
model.}
\item{\code{lambda.min}}{Value of lambda from which the prediction model is
used}
\item{\code{sd.cv}}{Difference in the number of standard deviations in
deviance between the model with lowest cross-validation error and the null
model}
\item{\code{ct}}{Time taken to generate predictions.}
\item{\code{vt}}{Time taken to estimate variance.}
}
\description{
Calculates SAVER estimate
}
\details{
The SAVER method starts by estimating the prior mean and variance for the
true expression level for each gene and cell. The prior mean is obtained
through predictions from a LASSO Poisson regression for each gene
implemented using the \code{glmnet} package. Then, the variance is estimated
through maximum likelihood assuming constant variance, Fano factor, or
coefficient of variation variance structure for each gene. The posterior
distribution is calculated and the posterior mean is reported as the SAVER
estimate.
}
