% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_density_ratio.R
\name{fit_density_ratio}
\alias{fit_density_ratio}
\title{Fit density-ratio distribution models in a plug-and-play framework.}
\usage{
fit_density_ratio(presence = NULL, background = NULL, method = NULL, ...)
}
\arguments{
\item{presence}{dataframe of covariates at presence points}

\item{background}{Dataframe of covariates at background points}

\item{method}{Character. See "notes" for options.}

\item{...}{Additional parameters passed to internal functions.}
}
\value{
List of class "dr_model" containing model objects and metadata needed for projecting the fitted models.
}
\description{
This function fits density-ratio species distribution models for
the specified density-ratio method \insertCite{Drake2018-ha}{S4DM}.
}
\details{
Current methods include: "ulsif", "rulsif", "maxnet"
}
\examples{
\donttest{

# load in sample data

 library(S4DM)
 library(terra)

 # occurrence points
   data("sample_points")
   occurrences <- sample_points

 # environmental data
   env <- rast(system.file('ex/sample_env.tif', package="S4DM"))

 # rescale the environmental data

   env <- scale(env)

 # Get presence environmental data

  pres_env <- get_env_pres(coords = occurrences,
                           env = env)

# Get background environmental data

 bg_env <- get_env_bg(coords = occurrences,
                      env = env,width = 100000)


# Note that the functions to get the environmental data return lists,
# and only the "env" element of these is used in the fit function

rulsif_fit <- fit_density_ratio(presence = pres_env$env,
                               background = bg_env$env,
                               method = "rulsif")

}
}
\references{
\insertAllCited{}
}
