% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcgUniformRemesh.r
\name{vcgUniformRemesh}
\alias{vcgUniformRemesh}
\title{Resample a mesh uniformly}
\usage{
vcgUniformRemesh(
  x,
  voxelSize = NULL,
  offset = 0,
  discretize = FALSE,
  multiSample = FALSE,
  absDist = FALSE,
  mergeClost = FALSE,
  silent = FALSE
)
}
\arguments{
\item{x}{triangular mesh}

\item{voxelSize}{voxel size for space discretization}

\item{offset}{Offset of the created surface (i.e. distance of the created surface from the original one).}

\item{discretize}{If TRUE, the position of the intersected edge of the marching cube grid is not computed by linear interpolation, but it is placed in fixed middle position. As a consequence the resampled object will look severely aliased by a stairstep appearance.}

\item{multiSample}{If TRUE, the distance field is more accurately compute by multisampling the volume (7 sample for each voxel). Much slower but less artifacts.}

\item{absDist}{If TRUE, an unsigned distance field is computed. In this case you have to choose a not zero Offset and a double surface is built around the original surface, inside and outside.}

\item{mergeClost}{logical: merge close vertices}

\item{silent}{logical: suppress messages}
}
\value{
resampled mesh
}
\description{
Resample a mesh uniformly
}
\examples{
\dontrun{
data(humface)
humresample <- vcgUniformRemesh(humface,voxelSize=1,multiSample = TRUE)
require(rgl)
shade3d(humresample,col=3)
}
}
