% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/troppca.linsp.R
\name{troppca.linsp}
\alias{troppca.linsp}
\title{Tropical Principal Component Analysis by Tropical Linear Space}
\usage{
troppca.linsp(x, pcs = 2, iteration = list(), ncores = 2)
}
\arguments{
\item{x}{a data matrix, of size n x e, with each row an observation vector.
e is the dimension of the tropical space}

\item{pcs}{a numeric value indicating the order of principal component. (default: 2)}

\item{iteration}{a list with arguments controlling the iteration of the algorithm.
\describe{
\item{exhaust}{a logical variable indicating if to iterate over all possible combinations of the linear space
based on the given data matrix \code{x}. If FALSE, please input a number of iteration for \code{niter}.
If TRUE, please enter 0 for \code{niter} and this function will iterate over all possible combinations of linear space.
This could be time consuming when \code{x} is large. (default: FALSE)}
\item{niter}{a numeric variable indicating the number of iterations. (default: 100)}
}}

\item{ncores}{a numeric value indicating the number of threads utilized for multi-cored CPUs. (default: 2)}
}
\value{
A list of S3 class \code{"troppca"}, including:
\item{pc}{The principal component as a tropical linear space}
\item{obj}{The tropical PCA objective, the sum of tropical distance from each point to the projection.}
\item{projection}{The projections of all data points.}
\item{type}{The geometry of principal component.}
}
\description{
Approximate the principal component as a tropical linear space
for a given data matrix and returns the results as an object of class \code{troppca}.
}
\examples{
\donttest{
library(Rfast)
n <- 100
e <- 10
sig2 <- 1
x <- rbind(rmvnorm(n, mu = c(5, -5, rep(0, e - 2)), sigma = diag(sig2, e)))
troppca_fit <- troppca.linsp(x)
}

}
