% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rgamma_c}
\alias{rgamma_c}
\title{Generates a Gamma-distributed sample}
\usage{
rgamma_c(n, b = 2, a = 1/2)
}
\arguments{
\item{n}{(int)}

\item{b}{(numeric) - shape parameter. Must be in the range \eqn{(0, \infty)}.}

\item{a}{(numeric) - scale parameter. Must be in the range \eqn{(0, \infty)}.}
}
\value{
a numeric vector containing a random sample with above parameters.
}
\description{
Returns a sample from a gamma-distributed random variable.
The function uses the Marsaglia-Tsang fast gamma method used to generate
the random samples. See more details below. The name was chosen so it
doesn't clash with R's native method.
}
\details{
The gamma distribution is given by the function:
\deqn{f(x) = \frac{1}{\Gamma(b)a^b}x^{b-1}e^{-x/a}, x > 0}
where \eqn{b} is a shape parameter and \eqn{a} is a scale parameter.
The RNG is given by Marsaglia and Tsang, "A Simple Method for
generating gamma variables", ACM Transactions on Mathematical
Software, Vol 26, No 3 (2000), p363-372.
Available at \doi{10.1145/358407.358414}.
The code is based on the original 'GSL' version, adapted to
use 'R' version of RNGs. All credits to the original authors.
Implemented by J.D.Lamb@btinternet.com, minor modifications for 'GSL'
by Brian Gough. Adapted to 'R' by Elias Haddad.
}
\examples{
sample_gamma <- rgamma_c(1000, 1, 1)
}
