% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{qsep}
\alias{qsep}
\title{Returns quantile from the Skewed Exponential Power distribution}
\usage{
qsep(
  x,
  m = 0,
  a = 2,
  b = 1,
  lambda = 0,
  method = 0L,
  step_size = 1e-04,
  tol = 1e-10,
  max_iter = 100L,
  verb = 0L
)
}
\arguments{
\item{x}{(numeric) - vector with values to evaluate CDF.}

\item{m}{(numeric) - the location parameter.}

\item{a}{(numeric) - the scale parameter.}

\item{b}{(numeric) - the shape parameter}

\item{lambda}{(numeric) - the skewness parameter.}

\item{method}{(numeric) - If 0, uses the Newton-Raphson procedure for
optimization. If 1, uses Steffensen.}

\item{step_size}{(numeric) - the size of the step in the numerical
optimization (gradient descent). Default is 1e-4.}

\item{tol}{(numeric) - error tolerance (default is 1e-10).}

\item{max_iter}{(numeric) - maximum number of iterations for the
optimization procedure (default is 100).}

\item{verb}{(numeric) - verbosity level of the process (default 0).}
}
\value{
a vector containing the values for the densities.
}
\description{
The \code{qsep} returns the Cumulative Distribution Function at point x for
the Skewed Exponential Power distribution with parameters \eqn{a}, \eqn{b}.
}
\details{
The  SEP is a exponential power distribution controlled
by four parameters, with formula:
\deqn{ f(x; m, b, a, \lambda) = 2 \Phi(w) e^{-|z|^b/b}/(c)}
where:
\deqn{z = (x-m)/a}
\deqn{w = sign(z) |z|^{(b/2)} \lambda \sqrt{2/b}}
\deqn{c = 2 ab^{(1/b)-1} \Gamma(1/b)}
with \eqn{\Phi} the cumulative normal distribution with mean zero and variance
one. The CDF is calculated through numerical integration using the GSL suite
and the quantile is solved by inversion using a root-finding algorithm
(Newton-Raphson by default).
}
