% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_data.R
\name{prepare_data}
\alias{prepare_data}
\title{Prepare choice data for estimation}
\usage{
prepare_data(
  form,
  choice_data,
  re = NULL,
  alternatives = NULL,
  ordered = FALSE,
  ranked = FALSE,
  base = NULL,
  id = "id",
  idc = NULL,
  standardize = NULL,
  impute = "complete_cases"
)
}
\arguments{
\item{form}{[\code{formula}]\cr
A model description with the structure \code{choice ~ A | B | C}, where
\itemize{
\item \code{choice} is the name of the dependent variable (the choices),
\item \code{A} are names of alternative and choice situation specific
covariates with a coefficient that is constant across alternatives,
\item \code{B} are names of choice situation specific covariates with
alternative specific coefficients,
\item and \code{C} are names of alternative and choice situation specific
covariates with alternative specific coefficients.
}

Multiple covariates (of one type) are separated by a \code{+} sign.
By default, alternative specific constants (ASCs) are added to the model.
They can be removed by adding \code{+0} in the second spot.

In the ordered probit model (\code{ordered = TRUE}), the \code{formula}
object has the simple structure \code{choice ~ A}. ASCs are not estimated.}

\item{choice_data}{[\code{data.frame}]\cr
Choice data in wide format, where each row represents one choice occasion.}

\item{re}{[\code{character()} | \code{NULL}]\cr
Names of covariates with random effects.
If \code{re = NULL} (the default), there are no random effects.
To have random effects for the ASCs, include \code{"ASC"} in \code{re}.}

\item{alternatives}{[\code{character()}]\cr
The names of the choice alternatives. If not specified, the choice set is
defined by the observed choices.

If \code{ordered = TRUE}, \code{alternatives} is assumed to be specified with
the alternatives ordered from worst to best.}

\item{ordered}{[\code{logical(1)}]\cr
If \code{TRUE}, the choice set \code{alternatives} is assumed to be ordered
from worst to best.}

\item{ranked}{[\code{logical(1)}]\cr
Are the alternatives ranked?}

\item{base}{[\code{character(1)}]\cr
The name of the base alternative for covariates that are not
alternative specific (i.e. type 2 covariates and ASCs).

Ignored and set to \code{NULL} if the model has no alternative specific
covariates (e.g. in the ordered probit model).

By default, \code{base} is the last element of \code{alternatives}.}

\item{id}{[\code{character(1)}]\cr
The name of the column in \code{choice_data} that contains unique identifier
for each decision maker.}

\item{idc}{[\code{character(1)}]\cr
The name of the column in \code{choice_data} that contains
unique identifier for each choice situation of each decision maker.
By default, these identifier are generated by the order of appearance.}

\item{standardize}{[\code{character()} | \code{"all"}]\cr
Names of covariates that get standardized.

Covariates of type 1 or 3 have to be addressed by
\code{<covariate>_<alternative>}.

If \code{standardize = "all"}, all covariates get standardized.}

\item{impute}{A character that specifies how to handle missing covariate entries in
\code{choice_data}, one of:
\itemize{
\item \code{"complete_cases"}, removes all rows containing missing
covariate entries (the default),
\item \code{"zero"}, replaces missing covariate entries by zero
(only for numeric columns),
\item \code{"mean"}, imputes missing covariate entries by the mean
(only for numeric columns).
}}
}
\value{
An object of class \code{RprobitB_data}.
}
\description{
This function prepares choice data for estimation.
}
\details{
Requirements for the \code{data.frame} \code{choice_data}:
\itemize{
\item It \strong{must} contain a column named \code{id} which contains unique
identifier for each decision maker.
\item It \strong{can} contain a column named \code{idc} which contains unique
identifier for each choice situation of each decision maker.
If this information is missing, these identifier are generated
automatically by the appearance of the choices in the data set.
\item It \strong{can} contain a column named \code{choice} with the observed
choices, where \code{choice} must match the name of the dependent
variable in \code{form}.
Such a column is required for model fitting but not for prediction.
\item It \strong{must} contain a numeric column named \emph{p_j} for each alternative
specific covariate \emph{p} in \code{form} and each choice alternative \emph{j}
in \code{alternatives}.
\item It \strong{must} contain a numeric column named \emph{q} for each covariate \emph{q}
in \code{form} that is constant across alternatives.
}

In the ordered case (\code{ordered = TRUE}), the column \code{choice} must
contain the full ranking of the alternatives in each choice occasion as a
character, where the alternatives are separated by commas, see the examples.

See \href{https://loelschlaeger.de/RprobitB/articles/v02_choice_data.html}{the vignette on choice data}
for more details.
}
\examples{
data <- prepare_data(
  form = choice ~ price + time + comfort + change | 0,
  choice_data = train_choice,
  re = c("price", "time"),
  id = "deciderID",
  idc = "occasionID",
  standardize = c("price", "time")
)

### ranked case
choice_data <- data.frame(
  "id" = 1:3, "choice" = c("A,B,C", "A,C,B", "B,C,A"), "cov" = 1
)
data <- prepare_data(
  form = choice ~ 0 | cov + 0,
  choice_data = choice_data,
  ranked = TRUE
)

}
\seealso{
\itemize{
\item \code{\link[=check_form]{check_form()}} for checking the model formula
\item \code{\link[=overview_effects]{overview_effects()}} for an overview of the model effects
\item \code{\link[=create_lagged_cov]{create_lagged_cov()}} for creating lagged covariates
\item \code{\link[=as_cov_names]{as_cov_names()}} for re-labeling alternative-specific covariates
\item \code{\link[=simulate_choices]{simulate_choices()}} for simulating choice data
\item \code{\link[=train_test]{train_test()}} for splitting choice data into a train and test subset
}
}
