% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_class_allocation}
\alias{plot_class_allocation}
\title{Plot class allocation (for \code{P_r = 2} only)}
\usage{
plot_class_allocation(beta, z, b, Omega, ...)
}
\arguments{
\item{beta}{[\code{matrix(nrow = P_r, ncol = N)}]\cr
The matrix of the decider-specific coefficient vectors.}

\item{z}{[\code{numeric(N)}]\cr
The decider class allocations.}

\item{b}{[\code{matrix(nrow = P_r, ncol = C)}]\cr
The matrix of class means as columns.}

\item{Omega}{[\code{matrix(nrow = P_r * P_r, ncol = C)}]\cr
The matrix of vectorized class covariance matrices as columns.}

\item{...}{Optional visualization parameters:
\itemize{
\item \code{colors}, a character vector of color specifications,
\item \code{perc}, a numeric between 0 and 1 to draw the \code{perc} percentile
ellipsoids for the underlying Gaussian distributions (\code{perc = 0.95} per default),
\item \code{r}, the current iteration number of the Gibbs sampler to be displayed in the legend,
\item \code{sleep}, the number of seconds to pause after plotting.
}}
}
\value{
No return value. Draws a plot to the current device.
}
\description{
This function plots the allocation of decision-maker specific coefficient vectors
\code{beta} given the allocation vector \code{z}, the class means \code{b},
and the class covariance matrices \code{Omega}.
}
\details{
Only applicable in the two-dimensional case, i.e. only if \code{P_r = 2}.
}
