% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_px_cm.R
\name{cm2px}
\alias{cm2px}
\alias{px2cm}
\title{Functions for converting pixels and centimeters}
\usage{
cm2px(cm, ppcm = NULL, ppi = NULL)

px2cm(px, ppcm = NULL, ppi = NULL)
}
\arguments{
\item{cm}{Numeric value or numeric vector (centimeters) to be converted
to pixels.}

\item{ppcm}{Numeric value or numeric vector (default NULL) of the same length
as \code{cm} or \code{px} specifying how many pixels there are per
centimeter.
If \code{ppcm} is not NULL, \code{ppi} is ignored.\cr
Examples: 300 ppi (printing) is 118 ppcm, 150 ppi is 59 ppcm,
72 ppi (screens) is 28 ppcm.}

\item{ppi}{Numeric value or numeric vector (default NULL) of the same length
as \code{cm} or \code{px} specifying how many pixels there are per inch.
Set \code{ppcm} to NULL to use \code{ppi}.\cr
Examples: 300 ppi (printing) is 118 ppcm, 150 ppi is 59 ppcm,
72 ppi (screens) is 28 ppcm.}

\item{px}{Numeric value or numeric vector (pixels) to be converted to
centimeters.}
}
\value{
\code{cm2px} Numeric value or numeric vector (pixels).

\code{px2cm} Numeric value or numeric vector (centimeters).
}
\description{
\code{cm2px} - Converts centimeters to pixels.

\code{px2cm} - Converts pixels to centimeters.
}
\examples{
cm2px(2, 4)
px2cm(2, 4)
}
