% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuneandtrainExtSVM.R
\name{tuneandtrainExtSVM}
\alias{tuneandtrainExtSVM}
\title{Tune and Train External SVM}
\usage{
tuneandtrainExtSVM(
  data,
  dataext,
  estperf = FALSE,
  kernel = "linear",
  cost_seq = 2^(-15:15),
  scale = FALSE
)
}
\arguments{
\item{data}{A data frame containing the training data. The first column should be the response variable (factor), 
and the remaining columns should be the predictor variables.}

\item{dataext}{A data frame containing the external validation data. The first column should be the response 
variable (factor), and the remaining columns should be the predictor variables.}

\item{estperf}{A logical value indicating whether to use internal tuning with external validation (\code{TRUE}) 
or external tuning (\code{FALSE}). Default is \code{FALSE}.}

\item{kernel}{A character string specifying the kernel type to be used in the SVM. Default is \code{"linear"}.}

\item{cost_seq}{A numeric vector specifying the sequence of cost values to evaluate. Default is \code{2^(-15:15)}.}

\item{scale}{A logical value indicating whether to scale the predictor variables. Default is \code{FALSE}.}
}
\value{
A list containing the following components:
  \itemize{
    \item \code{best_cost}: The optimal cost value determined during the tuning process.
    \item \code{best_model}: The trained SVM model using the selected \code{cost}.
    \item \code{est_auc}: The AUC value evaluated on the external dataset. This is only returned when \code{estperf = TRUE}, 
      providing a conservative (slightly pessimistic) estimate of the model's performance.
  }
}
\description{
This function tunes and trains a Support Vector Machine (SVM) classifier using the \code{mlr} package. 
It provides two strategies for tuning the cost parameter based on the \code{estperf} argument:
\itemize{
  \item When \code{estperf = FALSE} (default): Hyperparameters are tuned using the external validation dataset. 
        The \code{cost} value that gives the highest AUC on the external dataset is selected as the best model.
        However, no AUC value is returned in this case, as per best practices.
  \item When \code{estperf = TRUE}: Hyperparameters are tuned internally using the training dataset. 
        The model is then validated on the external dataset to provide a conservative (slightly pessimistic) AUC estimate.
}
}
\examples{
\donttest{
# Load sample data
data(sample_data_train)
data(sample_data_extern)

# Example usage with external tuning (default)
result <- tuneandtrainExtSVM(sample_data_train, sample_data_extern, kernel = "linear", 
  cost_seq = 2^(-15:15), scale = FALSE)
print(result$best_cost)        # Optimal cost
print(result$best_model)       # Final trained model
# Note: est_auc is not returned when estperf = FALSE

# Example usage with internal tuning and external validation
result_internal <- tuneandtrainExtSVM(sample_data_train, sample_data_extern, 
  estperf = TRUE, kernel = "linear", cost_seq = 2^(-15:15), scale = FALSE)
print(result_internal$best_cost)  # Optimal cost
print(result_internal$best_model) # Final trained model
print(result_internal$est_auc)    # AUC on external validation dataset
}
}
