% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.nest.R
\name{plot.nest}
\alias{plot.nest}
\title{Plot results of Next Eigenvalues Sufficiency Test (NEST)}
\usage{
\method{plot}{nest}(x, pa = FALSE, ...)
}
\arguments{
\item{x}{an object of class "nest".}

\item{pa}{show results of Parallel Analysis.}

\item{...}{further arguments for other methods, ignored for "nest".}
}
\value{
A ggplot output.
}
\description{
Scree plot of the eigenvalues and the \code{(1-alpha)*100\%} confidence intervals derived from the resampled eigenvalues supplied to \code{nest}.
}
\note{
This function is more interesting with many \code{alpha} values.
}
\examples{
results <- nest(ex_2factors, n = 100, alpha = c(.01, .05, .01))
plot(results)
# Return the data used to produce the plot
df <- plot(results)$data
}
