#' Emoji Master List
#'
#' A list of emoji Unicode values with human-friendly names.
#'
#' @docType data
#' @keywords emoji
#' @name emoji_dict
#' @usage data(emoji_dict)
#' @format A named list of emoji names and corresponding Unicode symbols.
#' @examples
#' data(emoji_dict)
#' head(emoji_dict)
NULL

emoji_dict <- list(

# Most commonly used emojies
  # Faces and Expressions
  smile = "\U0001F604",
  wink = "\U0001F609",
  sad = "\U0001F61E",
  surprised = "\U0001F62E",
  tongue_out = "\U0001F61B",
  angry = "\U0001F620",

  # People and Action
  person = "\U0001F9D1",
  family = "\U0001F46A",
  dancer = "\U0001F483",
  runner = "\U0001F3C3",
  worker = "\U0001F9D1\U0000200D\U0001F3ED",

  # Animals
  dog = "\U0001F436",
  cat = "\U0001F431",
  horse = "\U0001F40E",
  mouse = "\U0001F42D",
  lion = "\U0001F981",

  # Objects and Things
  heart = "\u2764\ufe0f",
  star = "\U00002B50",
  gift = "\U0001F381",
  lightbulb = "\U0001F4A1",
  fire = "\U0001F525",

  # Food
  pizza = "\U0001F355",
  apple = "\U0001F34E",
  burger = "\U0001F354",
  cake = "\U0001F370",
  ice_cream = "\U0001F368",

  # Weather
  sun = "\U00002600",
  cloud = "\U00002601",
  rainbow = "\U0001F308",
  thunderstorm = "\U0001F329",
  snowflake = "\U00002744",

  # Travel and Places
  airplane = "\U0001F6E9",
  car = "\U0001F697",
  bus = "\U0001F68C",
  mountain = "\U0001F3D4",
  beach = "\U0001F3D6",

  # Symbols
  check = "\U00002705",
  cross = "\U0000274C",
  warning = "\U000026A0",
  info = "\U00002139",
  question = "\U00002753",
  stop = "\U0001F6D1",

  # Programming
  package = "\U0001F4E6",
  cran = "\U0001F4E6",
  laptop = "\U0001F4BB",
  devtools = "\U0001F4D8",
  setting = "\U00002699",

  # charts
  barchart = "\U0001F4CA",
  increasing = "\U0001F4C8",

  # hearts
  `Red Heart` = "\u2764\ufe0f",
  `Blue Heart` = "\U0001F499",
  `Green Heart` = "\U0001F49A",
  `Yellow Heart` = "\U0001F49B",
  `Purple Heart` = "\U0001F49C",
  `Black Heart` = "\U0001F5A4",
  `White Heart` = "\U0001F90D",
  `Brown Heart` = "\U0001F90E",

  # coffee
  coffee = "\u2615",

  # Other
  wrench = "\U0001F527",
  sparkles = "\u2728",
  brain = "\U0001F9E0",
  pain = "\U0001F623",
  pregnancy = "\U0001F930",
  keyboard = "\U00002328",
  announcement = "\U0001F4E2",
  globe = "\U0001F30D",
  sparkling_heart <- "\U0001F496",
  bug = "\U0001F41B",
  goat = "\U1F410",

  # Punctuation marks
  Double_Exclamation_Mark = "\U0000203C",
  Exclamation_Question_Mark = "\U00002049",
  Red_Question_Mark = "\U00002753",
  White_Question_Mark = "\U00002754",
  White_Exclamation_Mark = "\U00002755",
  Red_Exclamation_Mark = "\U00002757",
  Wavy_Dash = "\U00003030",

 # Other from
  Medical_Symbol = "\U00002695",
  Recycling_Symbol = "\U0000267B",
  Fleur_de_lis = "\U0000269C",
  Trident_Emblem = "\U0001F531",
  Name_Badge = "\U0001F4DB",
  Japanese_Symbol_for_Beginner = "\U0001F530",
  Hollow_Red_Circle = "\U00002B55",
  Check_Mark_Button = "\U00002705",
  Check_Box_With_Check = "\U00002611",
  Check_Mark = "\U00002714",
  Cross_Mark = "\U0000274C",
  Cross_Mark_Button = "\U0000274E",
  Curly_Loop = "\U000027B0",
  Double_Curly_Loop = "\U000027BF",
  Part_Alternation_Mark = "\U0000303D",
  Eight_Spoked_Asterisk = "\U00002733",
  Eight_Point_Star = "\U00002734",
  Sparkle = "\U00002747",
  Copyright_Symbol = "\U000000A9",
  Registered_Symbol = "\U000000AE",

 # Math
 Multiply = "\U00002716",
 Plus = "\U00002795",
 Minus = "\U00002796",
 Divide = "\U00002797",
 Heavy_Equals_Sign = "\U0001F7F0",
 Infinity = "\U0000267E",

 # gender
 Female_Sign = "\U00002640",
 Male_Sign = "\U00002642",
 Transgender_Symbol = "\U000026A7",

 # Gender

 Place_of_Worship = "\U0001F6D0",
 Atom_Symbol = "\U0000269B",
 Om = "\U0001F549",
 Star_of_David = "\U00002721",
 Wheel_of_Dharma = "\U00002638",
 Yin_Yang = "\U0000262F",
 Latin_Cross = "\U0000271D",
 Orthodox_Cross = "\U00002626",
 Star_and_Crescent = "\U0000262A",
 Peace_Symbol = "\U0000262E",
 Menorah = "\U0001F54E",
 Dotted_Six_Pointed_Star = "\U0001F52F",
 Khanda = "\U0001FAAF",

 # Arrow
 Up_Arrow = "\U00002B06",
 Up_Right_Arrow = "\U00002197",
 Right_Arrow = "\U000027A1",
 Down_Right_Arrow = "\U00002198",
 Down_Arrow = "\U00002B07",
 Down_Left_Arrow = "\U00002199",
 Left_Arrow = "\U00002B05",
 Up_Left_Arrow = "\U00002196",
 Up_Down_Arrow = "\U00002195",
 Left_Right_Arrow = "\U00002194",
 Right_Arrow_Curving_Left = "\U000021A9",
 Left_Arrow_Curving_Right = "\U000021AA",
 Right_Arrow_Curving_Up = "\U00002934",
 Right_Arrow_Curving_Down = "\U00002935",
 Clockwise_Vertical_Arrows = "\U0001F503",
 Counterclockwise_Arrows_Button = "\U0001F504",
 Back_Arrow = "\U0001F519",
 End_Arrow = "\U0001F51A",
 On_Arrow = "\U0001F51B",
 Soon_Arrow = "\U0001F51C",

 # Warnning

 Warning = "\U000026A0",
 Children_Crossing = "\U0001F6B8",
 No_Entry = "\U000026D4",
 Prohibited = "\U0001F6AB",
 No_Bicycles = "\U0001F6B3",
 No_Smoking = "\U0001F6AD",
 No_Littering = "\U0001F6AF",
 Non_Potable_Water = "\U0001F6B1",
 No_Pedestrians = "\U0001F6B7",
 No_Mobile_Phones = "\U0001F4F5",
 No_One_Under_Eighteen = "\U0001F51E",
 Radioactive = "\U00002622",
 Biohazard = "\U00002623",

 # Transport sign

 ATM_Sign = "\U0001F3E7",
 Litter_in_Bin_Sign = "\U0001F6AE",
 Potable_Water = "\U0001F6B0",
 Wheelchair_Symbol = "\U0000267F",
 Mens_Room = "\U0001F6B9",
 Womens_Room = "\U0001F6BA",
 Restroom = "\U0001F6BB",
 Baby_Symbol = "\U0001F6BC",
 Water_Closet = "\U0001F6BE",
 Passport_Control = "\U0001F6C2",
 Customs = "\U0001F6C3",
 Baggage_Claim = "\U0001F6C4",
 Left_Luggage = "\U0001F6C5",

 # Medical
 Syringe = "\U0001F489",
 Drop_of_Blood = "\U0001FA78",
 Pill = "\U0001F48A",
 Adhesive_Bandage = "\U0001FA79",
 Crutch = "\U0001FA7C",
 Stethoscope = "\U0001FA7A",
 XRay = "\U0001FA7B",

# Science

Alembic = "\U00002697",
Test_Tube = "\U0001F9EA",
Petri_Dish = "\U0001F9EB",
DNA = "\U0001F9EC",
Microscope = "\U0001F52C",
Telescope = "\U0001F52D",
Satellite_Antenna = "\U0001F4E1",

# Tool

Hammer = "\U0001F528",
Axe = "\U0001FA93",
Pick = "\U000026CF",
Hammer_and_Pick = "\U00002692",
Hammer_and_Wrench = "\U0001F6E0",
Dagger = "\U0001F5E1",
Crossed_Swords = "\U00002694",
Bomb = "\U0001F4A3",
Boomerang = "\U0001FA83",
Bow_and_Arrow = "\U0001F3F9",
Shield = "\U0001F6E1",
Carpentry_Saw = "\U0001FA9A",
Wrench = "\U0001F527",
Screwdriver = "\U0001FA9B",
Nut_and_Bolt = "\U0001F529",
Gear = "\U00002699",
Clamp = "\U0001F5DC",
Balance_Scale = "\U00002696",
White_Cane = "\U0001F9AF",
Link = "\U0001F517",

# Lock

Locked = "\U0001F512",
Unlocked = "\U0001F513",
Locked_with_Pen = "\U0001F50F",
Locked_with_Key = "\U0001F510",
Key = "\U0001F511",
Old_Key = "\U0001F5DD",

# office

Briefcase = "\U0001F4BC",
File_Folder = "\U0001F4C1",
Open_File_Folder = "\U0001F4C2",
Card_Index_Dividers = "\U0001F5C2",
Calendar = "\U0001F4C5",
Tear_Off_Calendar = "\U0001F4C6",
Spiral_Notepad = "\U0001F5D2",
Spiral_Calendar = "\U0001F5D3",
Card_Index = "\U0001F4C7",
Chart_Increasing = "\U0001F4C8",
Chart_Decreasing = "\U0001F4C9",
Bar_Chart = "\U0001F4CA",
Clipboard = "\U0001F4CB",
Pushpin = "\U0001F4CC",
Round_Pushpin = "\U0001F4CD",
Paperclip = "\U0001F4CE",
Linked_Paperclips = "\U0001F587",
Straight_Ruler = "\U0001F4CF",
Triangular_Ruler = "\U0001F4D0",
Scissors = "\U00002702",

# Writting

Pencil = "\U0000270F",
Black_Nib = "\U00002712",
Fountain_Pen = "\U0001F58B",
Pen = "\U0001F58A",
Paintbrush = "\U0001F58C",
Crayon = "\U0001F58D",
Memo = "\U0001F4DD",

# mail

Envelope = "\U00002709",
Email = "\U0001F4E7",
Incoming_Envelope = "\U0001F4E8",
Envelope_with_Arrow = "\U0001F4E9",
Outbox_Tray = "\U0001F4E4",
Inbox_Tray = "\U0001F4E5",
Package = "\U0001F4E6",
Closed_Mailbox_Raised_Flag = "\U0001F4EB",
Closed_Mailbox_Lowered_Flag = "\U0001F4EA",
Open_Mailbox_Raised_Flag = "\U0001F4EC",
Open_Mailbox_Lowered_Flag = "\U0001F4ED",
Postbox = "\U0001F4EE",
Ballot_Box_with_Ballot = "\U0001F5F3",

# Sound
Muted_Speaker = "\U0001F507",
Speaker_Low_Volume = "\U0001F508",
Speaker_Medium_Volume = "\U0001F509",
Speaker_High_Volume = "\U0001F50A",
Loudspeaker = "\U0001F4E2",
Megaphone = "\U0001F4E3",
Postal_Horn = "\U0001F4EF",
Bell = "\U0001F514",
Bell_with_Slash = "\U0001F515",


# event

Jack_o_Lantern = "\U0001F383",
Christmas_Tree = "\U0001F384",
Fireworks = "\U0001F386",
Sparkler = "\U0001F387",
Firecracker = "\U0001F9E8",
Sparkles = "\U0002728",
Balloon = "\U0001F388",
Party_Popper = "\U0001F389",
Confetti_Ball = "\U0001F38A",
Tanabata_Tree = "\U0001F38B",
Pine_Decoration = "\U0001F38D",
Japanese_Dolls = "\U0001F38E",
Carp_Streamers = "\U0001F38F",
Wind_Chime = "\U0001F390",
Moon_Viewing_Ceremony = "\U0001F391",
Red_Envelope = "\U0001F9E7",
Ribbon = "\U0001F380",
Wrapped_Gift = "\U0001F381",
Reminder_Ribbon = "\U0001F397",
Admission_Tickets = "\U0001F39F",

#Place building

Stadium = "\U0001F3DF",
Classical_Building = "\U0001F3DB",
Building_Construction = "\U0001F3D7",
Brick = "\U0001F9F1",
Rock = "\U0001FAA8",
Wood = "\U0001FAB5",
Hut = "\U0001F6D6",
Houses = "\U0001F3D8",
Derelict_House = "\U0001F3DA",
House = "\U0001F3E0",
House_With_Garden = "\U0001F3E1",
Office_Building = "\U0001F3E2",
Japanese_Post_Office = "\U0001F3E3",
Post_Office = "\U0001F3E4",
Hospital = "\U0001F3E5",
Bank = "\U0001F3E6",
Hotel = "\U0001F3E8",
Love_Hotel = "\U0001F3E9",
Convenience_Store = "\U0001F3EA",
School = "\U0001F3EB",

# Religious places

Church = "\U000026EA",
Mosque = "\U0001F54C",
Hindu_Temple = "\U0001F6D5",
Synagogue = "\U0001F54D",
Shinto_Shrine = "\U000026E9",
Kaaba = "\U0001F54B",

# world

Globe_Europe_Africa = "\U0001F30D",
Globe_Americas = "\U0001F30E",
Globe_Asia_Australia = "\U0001F30F",
Globe_Meridians = "\U0001F310",
World_Map = "\U0001F5FA",
Map_of_Japan = "\U0001F5FE",
Compass = "\U0001F9ED",

# hands

Clapping_Hands = "\U0001F44F",
Raising_Hands = "\U0001F64C",
Heart_Hands = "\U0001FAF6",
Open_Hands = "\U0001F450",
Palms_Up_Together = "\U0001F932",
Handshake = "\U0001F91D",
Folded_Hands = "\U0001F64F",
Thumbs_Up = "\U0001F44D",
Thumbs_Down = "\U0001F44E",
Raised_Fist = "\U000270A",
Oncoming_Fist = "\U0001F44A",
Left_Facing_Fist = "\U0001F91B",
Right_Facing_Fist = "\U0001F91C",
OK_Hand = "\U0001F44C",
Pinched_Fingers = "\U0001F90C",
Pinching_Hand = "\U0001F90F",
Victory_Hand = "\U000270C",
Crossed_Fingers = "\U0001F91E",
Hand_With_Index_Finger_And_Thumb_Crossed = "\U0001FAF0",
Love_You_Gesture = "\U0001F91F",
Sign_Of_The_Horns = "\U0001F918",
Call_Me_Hand = "\U0001F919",

# Emotion

Kiss_Mark = "\U0001F48B",
Hundred_Points = "\U0001F4AF",
Anger_Symbol = "\U0001F4A2",
Collision = "\U0001F4A5",
Dizzy = "\U0001F4AB",
Sweat_Droplets = "\U0001F4A6",
Dashing_Away = "\U0001F4A8",
Hole = "\U0001F573",
Speech_Balloon = "\U0001F4AC",
Eye_In_Speech_Bubble = "\U0001F441\U000FE0F\U000200D\U0001F5E8\U000FE0F",
Left_Speech_Bubble = "\U0001F5E8",
Right_Anger_Bubble = "\U0001F5EF",
Thought_Balloon = "\U0001F4AD",
ZZZ = "\U0001F4A4",

# heart
Love_Letter = "\U0001F48C",
Heart_With_Arrow = "\U0001F498",
Heart_With_Ribbon = "\U0001F49D",
Sparkling_Heart = "\U0001F496",
Growing_Heart = "\U0001F497",
Beating_Heart = "\U0001F493",
Revolving_Hearts = "\U0001F49E",
Two_Hearts = "\U0001F495",
Heart_Decoration = "\U0001F49F",
Heart_Exclamation = "\U00002763",
Broken_Heart = "\U0001F494",
Heart_On_Fire = "\U00002764\U000FE0F\U000200D\U0001F525",
Mending_Heart = "\U00002764\U000FE0F\U000200D\U0001FA79",
Red_Heart = "\U00002764",
Pink_Heart = "\U0001FA77",
Orange_Heart = "\U0001F9E1",
Yellow_Heart = "\U0001F49B",
Green_Heart = "\U0001F49A",
Blue_Heart = "\U0001F499",
Light_Blue_Heart = "\U0001FA75",
Purple_Heart = "\U0001F49C",
Brown_Heart = "\U0001F90E",
Black_Heart = "\U0001F5A4",
Grey_Heart = "\U0001FA76",
White_Heart = "\U0001F90D",

# cat face
Grinning_Cat = "\U0001F63A",
Grinning_Cat_With_Smiling_Eyes = "\U0001F638",
Cat_With_Tears_Of_Joy = "\U0001F639",
Smiling_Cat_With_Heart_Eyes = "\U0001F63B",
Cat_With_Wry_Smile = "\U0001F63C",
Kissing_Cat = "\U0001F63D",
Weary_Cat = "\U0001F640",
Crying_Cat = "\U0001F63F",
Pouting_Cat = "\U0001F63E",

# Face angry

Face_With_Steam_From_Nose = "\U0001F624",
Enraged_Face = "\U0001F621",
Angry_Face = "\U0001F620",
Face_With_Symbols_On_Mouth = "\U0001F92C",
Smiling_Face_With_Horns = "\U0001F608",
Angry_Face_With_Horns = "\U0001F47F",
Skull = "\U0001F480",
Skull_And_Crossbones = "\U00002620",

# preserving face
Persevering_Face = "\U0001F623",
Disappointed_Face = "\U0001F61E",
Downcast_Face_With_Sweat = "\U0001F613",
Weary_Face = "\U0001F629",
Tired_Face = "\U0001F62B",
Yawning_Face = "\U0001F971",

Confused_Face = "\U0001F615",
Face_With_Diagonal_Mouth = "\U0001FAE4",
Worried_Face = "\U0001F61F",
Slightly_Frowning_Face = "\U0001F641",
Frowning_Face = "\U0002639",
Face_With_Open_Mouth = "\U0001F62E",
Hushed_Face = "\U0001F62F",
Astonished_Face = "\U0001F632",
Flushed_Face = "\U0001F633",
Pleading_Face = "\U0001F97A",
Face_Holding_Back_Tears = "\U0001F979",
Frowning_Face_With_Open_Mouth = "\U0001F626",
Anguished_Face = "\U0001F627",
Fearful_Face = "\U0001F628",
Anxious_Face_With_Sweat = "\U0001F630",
Sad_But_Relieved_Face = "\U0001F625",
Crying_Face = "\U0001F622",
Loudly_Crying_Face = "\U0001F62D",
Face_Screaming_In_Fear = "\U0001F631",
Confounded_Face = "\U0001F616",

# smile
Smiling_Face_With_Sunglasses = "\U0001F60E",
Nerd_Face = "\U0001F913",
Face_With_Monocle = "\U0001F9D0",

#hat
Cowboy_Hat_Face = "\U0001F920",
Partying_Face = "\U0001F973",
Disguised_Face = "\U0001F978",

# face unwell

Face_with_Medical_Mask = "\U0001F637",
Face_with_Thermometer = "\U0001F912",
Face_with_Head_Bandage = "\U0001F915",
Nauseated_Face = "\U0001F922",
Face_Vomiting = "\U0001F92E",
Sneezing_Face = "\U0001F927",
Hot_Face = "\U0001F975",
Cold_Face = "\U0001F976",
Woozy_Face = "\U0001F974",
Face_with_Crossed_Out_Eyes = "\U0001F635",
Face_with_Spiral_Eyes = "\U0001F635\U200D\U0001F4AB",
Exploding_Head = "\U0001F92F",


Relieved_Face = "\U0001F60C",
Pensive_Face = "\U0001F614",
Sleepy_Face = "\U0001F62A",
Drooling_Face = "\U0001F924",
Sleeping_Face = "\U0001F634",
Face_with_Bags_Under_Eyes = "\U0001FAE9",

Zipper_Mouth_Face = "\U0001F910",
Face_with_Raised_Eyebrow = "\U0001F928",
Neutral_Face = "\U0001F610",
Expressionless_Face = "\U0001F611",
Face_Without_Mouth = "\U0001F636",
Dotted_Line_Face = "\U0001FAE5",
Face_in_Clouds = "\U0001F636\U200D\U1F32B\UFE0F",
Smirking_Face = "\U0001F60F",
Unamused_Face = "\U0001F612",
Face_with_Rolling_Eyes = "\U0001F644",
Grimacing_Face = "\U0001F62C",
Face_Exhaling = "\U0001F62E\U200D\U1F4A8",
Lying_Face = "\U0001F925",
Shaking_Face = "\U0001FAE8",
Head_Shaking_Horizontally = "\U0001F642\U200D\U2194\UFE0F",
Head_Shaking_Vertically = "\U0001F642\U200D\U2195\UFE0F",

Smiling_Face_with_Open_Hands = "\U0001F917",
Face_with_Hand_Over_Mouth = "\U0001F92D",
Face_with_Open_Eyes_and_Hand_Over_Mouth = "\U0001FAE2",
Face_with_Peeking_Eye = "\U0001FAE3",
Shushing_Face = "\U0001F92B",
Thinking_Face = "\U0001F914",
Saluting_Face = "\U0001FAE1",


Face_Savoring_Food = "\U0001F60B",
Face_with_Tongue = "\U0001F61B",
Winking_Face_with_Tongue = "\U0001F61C",
Zany_Face = "\U0001F92A",
Squinting_Face_with_Tongue = "\U0001F61D",
Money_Mouth_Face = "\U0001F911",


Smiling_Face_with_Hearts = "\U0001F970",
Smiling_Face_with_Heart_Eyes = "\U0001F60D",
Star_Struck = "\U0001F929",
Face_Blowing_a_Kiss = "\U0001F618",
Kissing_Face = "\U0001F617",
Smiling_Face = "\U000263A",
Kissing_Face_with_Closed_Eyes = "\U0001F61A",
Kissing_Face_with_Smiling_Eyes = "\U0001F619",
Smiling_Face_with_Tear = "\U0001F972",

Grinning_Face = "\U0001F600",
Grinning_Face_with_Big_Eyes = "\U0001F603",
Grinning_Face_with_Smiling_Eyes = "\U0001F604",
Beaming_Face_with_Smiling_Eyes = "\U0001F601",
Grinning_Squinting_Face = "\U0001F606",
Grinning_Face_with_Sweat = "\U0001F605",
Rolling_on_the_Floor_Laughing = "\U0001F923",
Face_with_Tears_of_Joy = "\U0001F602",
Slightly_Smiling_Face = "\U0001F642",
`Upside-Down_Face` = "\U0001F643",
Melting_Face = "\U0001FAE0",
Winking_Face = "\U0001F609",
Smiling_Face_with_Smiling_Eyes = "\U0001F60A",
Smiling_Face_with_Halo = "\U0001F607",

# Bullet point emojies

blue_diamond = "\U1F539",
orange_diamond = "\U1F538",
red_triangle_up = "\U1F53A",
red_triangle_down = "\U1F53B",
small_black_square = "\u25AA",
small_white_square = "\u25AB",
classic_bullet = "\u2022",
arrowhead = "\u2794",
checkmark = "\u2705",
arrowhead = "\u2794",
item_lead_in = "\u27A4",
arrow_right = "\u2192",
triangle_bullet = "\u25B6",
broom = "\U0001F9F9",

# color and Identity

finish_line_flag = "\U1F3C1",
triangular_flag = "\U1F6A9",
crossed_flags = "\U1F38C",
black_flag = "\U1F3F4",
white_flag = "\U1F3F3",
rainbow_flag = "\U1F3F3\UFE0F\U200D\U1F308",
transgender_flag = "\U1F3F3\UFE0F\U200D\U26A7\UFE0F",
pirate_flag = "\U1F3F4\U200D\U2620\UFE0F",
un_flag = "\U1F1FA\U1F1F3",

# Africa flags
Angola = "\U1F1E6\U1F1F4",
`Burkina Faso` = "\U1F1E7\U1F1F6",
Burundi = "\U1F1E7\U1F1EE",
Benin = "\U1F1E7\U1F1EF",
Botswana = "\U1F1E7\U1F1FC",
DRCongo = "\U1F1E8\U1F1F4",
`Central African Republic` = "\U1F1E8\U1F1EB",
Congo = "\U1F1E8\U1F1EC",
`Ivory Coast` = "\U1F1E8\U1F1EE",
Cameroon = "\U1F1E8\U1F1F2",
`Cape Verde` = "\U1F1E8\U1F1FB",
Djibouti = "\U1F1E9\U1F1EF",
Algeria = "\U1F1E9\U1F1FF",
Egypt = "\U1F1EA\U1F1EC",
`Western Sahara` = "\U1F1EA\U1F1F8",
Eritrea = "\U1F1EA\U1F1F7",
Ethiopia = "\U1F1EA\U1F1F9",
Gabon = "\U1F1EC\U1F1E6",
Ghana = "\U1F1EC\U1F1F7",
Gambia = "\U1F1EC\U1F1F2",
Guinea = "\U1F1EC\U1F1F3",
`Equatorial Guinea` = "\U1F1EC\U1F1F6",
`Guinea Bissau` = "\U1F1EC\U1F1FC",
Kenya = "\U1F1F0\U1F1EA",
Comoros = "\U1F1F0\U1F1F2",
Liberia = "\U1F1F1\U1F1F7",
Lesotho = "\U1F1F1\U1F1F8",
Libya = "\U1F1F1\U1F1FE",
Morocco = "\U1F1F2\U1F1E6",
Madagascar = "\U1F1F2\U1F1EC",
Mali = "\U1F1F2\U1F1F1",
Mauritania = "\U1F1F2\U1F1F8",
Mauritius = "\U1F1F2\U1F1FA",
Malawi = "\U1F1F2\U1F1FC",
Mozambique = "\U1F1F2\U1F1FF",
Namibia = "\U1F1F3\U1F1F2",
Niger = "\U1F1F3\U1F1EA",
Nigeria = "\U1F1F3\U1F1EC",
Rwanda = "\U1F1F7\U1F1F7",
Seychelles = "\U1F1F8\U1F1E8",
Sudan = "\U1F1F8\U1F1E9",
`Sierra Leone` = "\U1F1F8\U1F1F1",
Senegal = "\U1F1F8\U1F1F7",
Somalia = "\U1F1F8\U1F1F4",
`South Sudan` = "\U1F1F8\U1F1F8",
Swaziland = "\U1F1F8\U1F1FF",
Chad = "\U1F1F9\U1F1E9",
Togo = "\U1F1F9\U1F1F4",
Tunisia = "\U1F1F9\U1F1F3",
Tanzania = "\U1F1F9\U1F1FF",
Uganda = "\U1F1FA\U1F1EC",
`South Africa` = "\U1F1FF\U1F1E6",
Zambia = "\U1F1FF\U1F1F2",
Zimbabwe = "\U1F1FF\U1F1FC",

# The Americas

Anguilla = "\U1F1E6\U1F1EE",
Antarctica = "\U1F1E6\U1F1F8",
Argentina = "\U1F1E6\U1F1F7",
Aruba = "\U1F1E6\U1F1FC",
Barbados = "\U1F1E7\U1F1E7",
`Saint Barthelemy` = "\U1F1E7\U1F1F1",
Bermuda = "\U1F1E7\U1F1F2",
Bolivia = "\U1F1E7\U1F1F4",
Bonaire = "\U1F1E7\U1F1F7",
Brazil = "\U1F1E7\U1F1F7",
Bahamas = "\U1F1E7\U1F1F8",
Belize = "\U1F1E7\U1F1FF",
Canada = "\U1F1E8\U1F1E6",
Chile = "\U1F1E8\U1F1F1",
Colombia = "\U1F1E8\U1F1F4",
CostaRica = "\U1F1E8\U1F1F7",
Cuba = "\U1F1E8\U1F1FA",
Curacao = "\U1F1E8\U1F1FC",
Dominica = "\U1F1E9\U1F1F2",
`Dominican Republic` = "\U1F1E9\U1F1F0",
Ecuador = "\U1F1EA\U1F1E8",
`Falkland Islands` = "\U1F1EB\U1F1F0",
Grenada = "\U1F1EC\U1F1E9",
`French Guiana` = "\U1F1EC\U1F1F7",
Guadeloupe = "\U1F1EC\U1F1F5",
Guatemala = "\U1F1EC\U1F1F9",
Guyana = "\U1F1EC\U1F1FE",
Honduras = "\U1F1ED\U1F1F3",
Haiti = "\U1F1ED\U1F1F9",
Jamaica = "\U1F1EF\U1F1F2",
`SaintKitts and Nevis` = "\U1F1F0\U1F1F3",
`Cayman Islands` = "\U1F1F0\U1F1FE",
`Saint Lucia` = "\U1F1F1\U1F1E8",
`Saint Martin` = "\U1F1F2\U1F1F6",
Montserrat = "\U1F1F2\U1F1F8",
Mexico = "\U1F1F2\U1F1F2",
Nicaragua = "\U1F1F3\U1F1EC",
Panama = "\U1F1F5\U1F1E6",
Peru = "\U1F1F5\U1F1ED",
`Saint Pierre and Miquelon` = "\U1F1F5\U1F1F7",
PuertoRico = "\U1F1F5\U1F1F8",
Paraguay = "\U1F1F5\U1F1FF",
Suriname = "\U1F1F8\U1F1F7",
ElSalvador = "\U1F1F8\U1F1FB",
`Sint Maarten` = "\U1F1F8\U1F1FD",
`Turks and Caicos` = "\U1F1F9\U1F1E8",
`Trinidad and Tobago` = "\U1F1F9\U1F1F9",
`United States` = "\U1F1FA\U1F1F8",
Uruguay = "\U1F1FA\U1F1FE",
Venezuela = "\U1F1FB\U1F1EA",
`British Virgin Islands` = "\U1F1FB\U1F1EC",
`United States Virgin Islands` = "\U1F1FB\U1F1EE",

  # Asia and Middle East
`United Arab Emirates` = "\U1F1E6\U1F1EA",
Afghanistan = "\U1F1E6\U1F1F0",
Azerbaijan = "\U1F1E6\U1F1FF",
Bangladesh = "\U1F1E7\U1F1E9",
Bahrain = "\U1F1E7\U1F1ED",
Brunei = "\U1F1E7\U1F1F3",
Bhutan = "\U1F1E7\U1F1F9",
China = "\U1F1E8\U1F1F3",
`Hong Kong` = "\U1F1ED\U1F1F0",
Indonesia = "\U1F1EE\U1F1F7",
Israel = "\U1F1EE\U1F1F1",
India = "\U1F1EE\U1F1F3",
Iraq = "\U1F1EE\U1F1F6",
Iran = "\U1F1EE\U1F1F7",
Jordan = "\U1F1EF\U1F1F4",
Japan = "\U1F1EF\U1F1F5",
Kyrgyzstan = "\U1F1F0\U1F1F7",
Cambodia = "\U1F1F0\U1F1ED",
NorthKorea = "\U1F1F0\U1F1F5",
SouthKorea = "\U1F1F0\U1F1F7",
Kuwait = "\U1F1F0\U1F1FC",
Kazakhstan = "\U1F1F0\U1F1FF",
Laos = "\U1F1F1\U1F1E8",
Lebanon = "\U1F1F1\U1F1E8",
SriLanka = "\U1F1F1\U1F1F0",
Myanmar = "\U1F1F2\U1F1F2",
Mongolia = "\U1F1F2\U1F1F3",
Macao = "\U1F1F2\U1F1F4",
Maldives = "\U1F1F2\U1F1F8",
Malaysia = "\U1F1F2\U1F1FE",
Nepal = "\U1F1F3\U1F1F5",
Oman = "\U1F1F4\U1F1F2",
Philippines = "\U1F1F5\U1F1F9",
Pakistan = "\U1F1F5\U1F1F0",
Palestine = "\U1F1F5\U1F1F8",
Qatar = "\U1F1F7\U1F1F4",
Russia = "\U1F1F7\U1F1FA",
`Saudi Arabia` = "\U1F1F8\U1F1E6",
Singapore = "\U1F1F8\U1F1EC",
Syria = "\U1F1F8\U1F1FE",
Thailand = "\U1F1F9\U1F1F0",
Tajikistan = "\U1F1F9\U1F1EF",
TimorLeste = "\U1F1F9\U1F1F1",
Turkmenistan = "\U1F1F9\U1F1F2",
Turkey = "\U1F1F9\U1F1F7",
Taiwan = "\U1F1F9\U1F1FC",
Uzbekistan = "\U1F1FA\U1F1FF",
Vietnam = "\U1F1FB\U1F1F3",
Yemen = "\U1F1FE\U1F1EA",

  # Europe
Albania = "\U1F1E6\U1F1F1",
Armenia = "\U1F1E6\U1F1F2",
Austria = "\U1F1E6\U1F1F9",
`Bosnia Herzegovina` = "\U1F1E7\U1F1E6",
Belgium = "\U1F1E7\U1F1EA",
Bulgaria = "\U1F1E7\U1F1EC",
Belarus = "\U1F1E7\U1F1FE",
Switzerland = "\U1F1E8\U1F1ED",
Cyprus = "\U1F1E8\U1F1FE",
`Czech Republic` = "\U1F1E8\U1F1FF",
Germany = "\U1F1E9\U1F1F7",
Denmark = "\U1F1E9\U1F1F0",
Spain = "\U1F1EA\U1F1F8",
Estonia = "\U1F1EA\U1F1EA",
`European Union` = "\U1F1EA\U1F1FA",
Finland = "\U1F1EB\U1F1EE",
France = "\U1F1EB\U1F1F7",
`United Kingdom` = "\U1F1EC\U1F1E7",
Georgia = "\U1F1EC\U1F1F7",
Guernsey = "\U1F1EC\U1F1EC",
Gibraltar = "\U1F1EC\U1F1F2",
Greece = "\U1F1EC\U1F1F7",
Croatia = "\U1F1ED\U1F1F7",
Hungary = "\U1F1ED\U1F1F9",
Ireland = "\U1F1EE\U1F1F7",
IsleOfMan = "\U1F1EE\U1F1F2",
Iceland = "\U1F1EE\U1F1F8",
Italy = "\U1F1EE\U1F1F9",
Jersey = "\U1F1EF\U1F1F8",
Liechtenstein = "\U1F1F1\U1F1F0",
Lithuania = "\U1F1F1\U1F1F9",
Luxembourg = "\U1F1F1\U1F1F8",
Latvia = "\U1F1F1\U1F1FB",
Monaco = "\U1F1F2\U1F1E8",
Moldova = "\U1F1F2\U1F1E9",
Montenegro = "\U1F1F2\U1F1EC",
`North Macedonia` = "\U1F1F2\U1F1F0",
Malta = "\U1F1F2\U1F1F9",
Netherlands = "\U1F1F3\U1F1F1",
Norway = "\U1F1F3\U1F1F4",
Poland = "\U1F1F5\U1F1F1",
Portugal = "\U1F1F5\U1F1F9",
Romania = "\U1F1F7\U1F1F4",
Serbia = "\U1F1F7\U1F1F8",
Russia = "\U1F1F7\U1F1FA",
Sweden = "\U1F1F8\U1F1ED",
Slovenia = "\U1F1F8\U1F1EE",
Slovakia = "\U1F1F8\U1F1F0",
SanMarino = "\U1F1F8\U1F1F2",
Ukraine = "\U1F1FA\U1F1E6",
VaticanCity = "\U1F1FB\U1F1E6",
Kosovo = "\U1F1FD\U1F1F0",
England = "\U1F3F4\U1F3F4",
Scotland = "\U1F3F4\U1F3F4",
Wales = "\U1F3F4\U1F3F4",

  # Ocean Island and Teritories
`Ascension Island` = "\U1F1E6\U1F1E8",
Antarctica = "\U1F1E6\U1F1F6",
`American Samoa` = "\U1F1E6\U1F1F8",
Australia = "\U1F1E6\U1F1F4",
`Bouvet Island` = "\U1F1E7\U1F1F8",
`Cocos Keeling Islands` = "\U1F1E8\U1F1F0",
`Cook Islands` = "\U1F1E8\U1F1F1",
`Christmas Island` = "\U1F1E8\U1F1FD",
`Clipperton Island` = "\U1F1E8\U1F1F5",
DiegoGarcia = "\U1F1E9\U1F1F2",
Fiji = "\U1F1F8\U1F1F4",
`Federated States Of Micronesia` = "\U1F1F8\U1F1F2",
Greenland = "\U1F1F0\U1F1F7",
`South Georgia And South Sandwich Islands` = "\U1F1F8\U1F1F0",
Guam = "\U1F1EC\U1F1F2",
`Heard And McDonald Islands` = "\U1F1F7\U1F1F2",
CanaryIslands = "\U1F1EE\U1F1F8",
`British Indian Ocean Territory` = "\U1F1EE\U1F1F4",
Kiribati = "\U1F1F0\U1F1EE",
`Marshall Islands` = "\U1F1F2\U1F1F0",
`Northern Mariana Islands` = "\U1F1F3\U1F1F2",
`New Caledonia` = "\U1F1F3\U1F1F0",
`Norfolk Island` = "\U1F1F3\U1F1F4",
Nauru = "\U1F1F3\U1F1F7",
Niue = "\U1F1F3\U1F1F8",
`New Zealand` = "\U1F1F3\U1F1FF",
`French Polynesia` = "\U1F1F5\U1F1F6",
`Papua New Guinea` = "\U1F1F5\U1F1EC",
PitcairnIslands = "\U1F1F5\U1F1F3",
Palau = "\U1F1F5\U1F1FC",
Reunion = "\U1F1F7\U1F1F6",
SolomonIslands = "\U1F1F8\U1F1F7",
SaintHelena = "\U1F1F8\U1F1F8",
Svalbard = "\U1F1F8\U1F1F1",
`SaoTome and Principe` = "\U1F1F8\U1F1F4",
`TristanDa Cunha` = "\U1F1F9\U1F1F2",
`French Southern And Antarctic Lands` = "\U1F1F9\U1F1F7",
Tokelau = "\U1F1F9\U1F1F0",
Tonga = "\U1F1F9\U1F1F4",
Tuvalu = "\U1F1F9\U1F1F8",
`United States` = "\U1F1FA\U1F1F8",
`Saint Vincent And The Grenadines` = "\U1F1FB\U1F1E8",
Vanuatu = "\U1F1FB\U1F1FA",
`Wallis And Futuna` = "\U1F1FC\U1F1F8",
Samoa = "\U1F1F8\U1F1F0",
Mayotte = "\U1F1FE\U1F1F9",
`Aland Islands`  = "\U0001F1E6\U0001F1FD"
  )

# all emojies to lower

names(emoji_dict) <- tolower(names(emoji_dict))

