% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.rf.pred.val.R
\name{query.rf.pred.val}
\alias{query.rf.pred.val}
\title{Identify corresponding observed values for the response variable under the
terminal nodes for a random forest model by \code{ranger}}
\usage{
query.rf.pred.val(obj, data, id.name = FALSE, unique.by.id = FALSE, ...)
}
\arguments{
\item{obj}{An R object of class \code{ranger}.}

\item{data}{Input for training data.}

\item{id.name}{Use the IDs of the terminal nodes as names for the lists.}

\item{unique.by.id}{Only return results of unique terminal node IDs.}

\item{...}{Other parameters (will be ignored).}
}
\value{
A nested list of length \code{num.trees}.
}
\description{
The observed values (for the response variable) constituting the terminal
node associated with each observation are queried using the \code{ranger}
object and the training data.
The parameter \code{keep.inbag = TRUE} should be applied to call to
\code{ranger}.
}
\details{
The observations are found based on terminal node IDs. It should be noted
that the out-of-bag observations are not present in the indexes.
}
\examples{
data(iris)
rfObj <- ranger(
    Sepal.Length ~ Sepal.Width + Petal.Length + Petal.Width + Species,
    data = iris, num.trees = 5, keep.inbag = TRUE)
outList <- query.rf.pred.val(rfObj, iris)

}
\author{
Shangzhi Hong
}
