% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RepRev.R
\name{repRev}
\alias{repRev}
\title{Interactive Session with RevBayes}
\usage{
repRev(path = Sys.getenv("rb"), viewCode = FALSE, coerce = TRUE, use_wd = TRUE)
}
\arguments{
\item{path}{character - Path to the RevBayes executable. Defaults to Sys.getenv("rb"), which should be assigned upon first loading the package.}

\item{viewCode}{logical - If TRUE, code from the temporary file used to interact with RevBayes will be displayed in
the viewing pane. Default is FALSE. The option is mostly for developer convenience, and can be ignored
by most users.}

\item{coerce}{logical - If FALSE, RevBayes output will be printed to the console in character format. If
TRUE, coerceRev() will attempt to coerce output into a suitable R object. Default is TRUE.}

\item{use_wd}{logical - If TRUE, the simulated Revbayes session will use the same working directory as
the active R session. If FALSE, it will use the default for the RevBayes executable. Default is TRUE.}
}
\value{
No return. RevBayes variables assigned within the session can be accessed externally via doRev() or viewed with getRevVars().
}
\description{
Simulates a continuous, interactive session with RevBayes. While this session is active, all code will be interpreted as Rev code, and attempting to run R code may result in error.
}
\details{
By default, the interactive session uses the present R working directory as the RevBayes working directory. This behavior can be turned off with use_wd = FALSE

The exit the session, type 'quit()', 'q()', or hit the 'esc' key.
clearRev(), getRevVars(), and getRevHistory() can still be called from within the session for user convenience
}
\examples{
\dontrun{
repRev()

myNumber <- 4
myNumber

posteriorPredictiveProbability(v(2), 3)
getrRev()
clearRev()
quit()
}
}
