% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_BigQuery_setup.R
\name{mod_bigquery}
\alias{mod_bigquery}
\alias{bigquery_setup_ui}
\alias{bigquery_setup_server}
\title{Google BigQuery Database Module}
\usage{
bigquery_setup_ui(id)

bigquery_setup_server(id, secrets_json = NULL)
}
\arguments{
\item{id}{The module namespace}

\item{secrets_json}{A string, containing a file path to a Google OAuth 2.0 Client
secrets JSON.}
}
\value{
\emph{bigquery_setup_ui}:
\item{tagList}{The Google BigQuery Setup UI}
\emph{bigquery_setup_server}:
\item{reactiveValues}{
\itemize{
\item{moduleName}: A string, containing the module moniker.
\item{moduleType}: A string, with the module type (what does it do?)
\item{setup_ui}: The module setup ui function
\item{is_connected}: A string, with module connection status. Valid statuses are
'yes' or 'no'.
\item{db_con}: A \link[DBI:dbConnect]{DBI::dbConnect} object, containing the user configured BigQuery
connection information.
\item{user_info}: A list, containing public user information from Google about
the currently authenticated user.
}}
}
\description{
This module is designed to guide a user through the process of authenticating with
Google BigQuery. It is responsible for retrieving:
\itemize{
\item{An OAuth 2.0 authorization token}
\item{A list of GCP projects that are available to the authenticated user}
\item{A list of BigQuery datasets contained within available projects}
}
The user is visually guided through the authentication process. Once authenticated,
the user is presented with project/dataset selections and once configured a
\code{\link[DBI:dbConnect]{DBI::dbConnect()}} object is returned.

This module consists of the following components:
\subsection{Module UI function}{

\itemize{
\item{\code{bigquery_setup_ui}}: A uiOutput responsible for guiding a user through
the Google OAuth 2.0 authorization flow and graphically selecting a Google Big
Query project/dataset.
}
}

\subsection{Module Server function}{

\itemize{
\item{\code{bigquery_setup_server}}: The logic that controls the graphical user
interface, including redirecting to Google, receiving an authorization code,
requesting an authorization token, and authenticating the application.
Ultimately responsible for returning public Google user information and a
\link[DBI:dbConnect]{DBI::dbconnect()} object used to connect to the configured BigQuery database.
}
}
}
\keyword{internal}
